package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.domain.NewsRecordMapper;
import com.bxm.localnews.news.service.NewsRecordService;
import com.bxm.localnews.news.vo.NewsRecord;
import com.bxm.localnews.news.vo.NewsRecordVO;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by hsq 10:35 2018/2/8
 */
@Service
public class NewsRecordServiceImpl implements NewsRecordService {

    @Resource
    private NewsRecordMapper newsRecordMapper;

    @Override
    public List<NewsRecordVO> queryRecordList(Long userId, MPage page) {
        List<NewsRecordVO> list = this.newsRecordMapper.queryRecordList(userId, page);
        return list;
    }

    @Override
    public Json deleteById(Long userId) {
        this.newsRecordMapper.updateRecord(userId);
        return ResultUtil.genSuccessResult();
    }

    @Override
    public Json updateById(Long id) {
        NewsRecord newsRecord = new NewsRecord(id, (byte) 1);
        this.newsRecordMapper.updateByPrimaryKeySelective(newsRecord);
        return ResultUtil.genSuccessResult();
    }

}
