package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.news.domain.VideoShareMapper;
import com.bxm.localnews.news.param.VideoShareParam;
import com.bxm.localnews.news.service.VideoShareService;
import com.bxm.localnews.news.vo.VideoShare;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VideoShareServiceImpl extends BaseService implements VideoShareService {

    @Autowired
    private RedisListAdapter redisListAdapter;

    @Override
    public Message produceVideoShare(VideoShareParam videoShareParam) {
        if (!checkParam(videoShareParam)) {
            return Message.build(false,"参数验证失败");
        }

        KeyGenerator keyGenerator = RedisConfig.VIDEO_QUEUE.copy().setKey("videoShareQueue");

        VideoShare videoShare = new VideoShare();
        BeanUtils.copyProperties(videoShareParam,videoShare);

        redisListAdapter.leftPush(keyGenerator,videoShare);

        return Message.build(true);
    }

    /**
     * 视频分享时参数验证
     * @param videoShareParam
     * @return
     */
    private boolean checkParam(VideoShareParam videoShareParam){
        return null != videoShareParam.getUserId()
                && null != videoShareParam.getVideoId()
                && null != videoShareParam.getType();
    }


}
