package com.bxm.localnews.payment.controller.facade;

import com.bxm.localnews.payment.proxy.WithdrawProxySerivce;
import com.bxm.localnews.payment.vo.WithdrawFlow;
import com.bxm.newidea.component.vo.Message;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author zhaoyadong 2019/3/12 20:32
 * @desc
 */
@Api(tags = "6-90 [内部接口]微信提现相关接口")
@RestController
@RequestMapping("facade/withdraw/manage")
@Slf4j
public class WithdrawFacadeController {

    @Autowired
    private WithdrawProxySerivce withdrawProxySerivce;

    @ApiOperation(value = "6-90-1 用户提现", notes = "用户直接提现")
    @PostMapping("")
    public void saveVipViewRecord(@RequestBody WithdrawFlow withdrawFlow) {
        //提现之前需要判断订单状态
        withdrawProxySerivce.withdraw(withdrawFlow);
    }

    @ApiOperation(value = "6-90-2 企业付款相关查询", notes = "查询有问题的订单--并做相应的处理")
    @GetMapping("")
    public ResponseEntity<Message> queryWithdraw(@RequestBody WithdrawFlow withdrawFlow) {
        return ResponseEntity.ok(withdrawProxySerivce.queryWithdraw(withdrawFlow));
    }
}
