package com.bxm.localnews.payment.controller.facade;

import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.domain.PaymentOrderMapper;
import com.bxm.localnews.payment.dto.PaymentOrderInfoDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

/**
 * @author jieliGG
 * @date 2020/9/1 16:07
 **/
@Api(tags = "6-50 [内部接口]支付相关参数对外提供")
@RequestMapping("facade/payment/pay")
@RestController
@Slf4j
public class PayFacadeController {

    @Autowired
    private PayProperties payProperties;
    //这里不建议使用mapper直接调用，但是我赶时间啊~~~~
    @Autowired
    private PaymentOrderMapper paymentOrderMapper;

    @ApiOperation("6-50-1 获取vip的相关信息")
    @GetMapping("getVipInfo")
    public ResponseEntity<PayProperties> getVipInfo(){
        return ResponseEntity.ok(payProperties);
    }

    /**
     * 根据订单号获取流水信息
     * @param orderNo
     * @return
     */
    @ApiOperation("6-50-2 根据订单号获取流水信息")
    @GetMapping("getPaymentNumByOrderSn")
    public ResponseEntity<PaymentOrderInfoDTO> getPaymentNumByOrderSn(@RequestParam("orderSn")String orderNo,
                                                                      @RequestParam(value = "status", required = false) Integer status){
        // 临时处理 如果这里没传状态 则默认返回支付成功的
        if (Objects.isNull(status)) {
            status = PaymentStatusEnum.SUCCEED.getType().intValue();
        }
        return ResponseEntity.ok(paymentOrderMapper.getByOrderSn(orderNo, status));
    }
}
