/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.dto.OrderStatusDTO;
import com.bxm.localnews.payment.dto.PaymentOrderDTO;
import com.bxm.localnews.payment.order.PaymentOrderFactory;
import com.bxm.localnews.payment.param.UserOrderParam;
import com.bxm.localnews.payment.pay.PaymentOrderService;
import com.bxm.newidea.component.util.WebUtils;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"6-01 \u652f\u4ed8\u76f8\u5173\u63a5\u53e3"}, description="\u5305\u62ec\u652f\u4ed8\u7684\u76f8\u5173\u63a5\u53e3\u64cd\u4f5c")
@RestController
@RequestMapping(value={"/api/pay"})
public class PayController {
    private PaymentOrderService payService;
    private final PaymentOrderFactory paymentOrderFactory;

    @Autowired
    public PayController(PaymentOrderService payService, PaymentOrderFactory paymentOrderFactory) {
        this.payService = payService;
        this.paymentOrderFactory = paymentOrderFactory;
    }

    @ApiOperation(value="6-01-1 [\u5df2\u5e9f\u5f03]\u7edf\u4e00\u4e0b\u5355\uff08\u8d2d\u4e70\u672c\u5730VIP\uff09\uff0c\u5e76\u7ec4\u88c5\u6240\u9700\u652f\u4ed8\u53c2\u6570", notes="\u65e7\u7248\u672c\u8d2d\u4e70\u7684\u672c\u5730VIP \u8bf7\u8c03\u75286-01-5\u521b\u5efa\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", dataType="Long", required=true), @ApiImplicitParam(name="payType", value="\u4ed8\u6b3e\u7c7b\u578b, 1:\u5fae\u4fe1\uff0c2\uff1a\u652f\u4ed8\u5b9d", allowableValues="1,2", required=true), @ApiImplicitParam(name="returnUrl", value="\u652f\u4ed8\u6210\u529f\u540e\u8df3\u8f6c\u5730\u5740", required=true)})
    @PostMapping(value={"/order"})
    @Deprecated
    public Json<PaymentOrderDTO> payOrder(Long userId, Byte payType, String returnUrl, HttpServletRequest request) {
        UserOrderParam param = new UserOrderParam();
        param.setUserId(userId);
        param.setPayType(payType);
        param.setReturnUrl(returnUrl);
        param.setRequestIp(WebUtils.getIpAddr((HttpServletRequest)request));
        param.setOrderType(OrderTypeEnum.LOCAL_VIP.getCode());
        PaymentOrderDTO order = this.paymentOrderFactory.build(param);
        if (order == null) {
            return ResultUtil.genFailedResult((String)"\u4f60\u5df2\u6210\u529f\u6fc0\u6d3bVIP,\u8bf7\u52ff\u91cd\u590d\u8d2d\u4e70");
        }
        return ResultUtil.genSuccessResult((Object)order);
    }

    @ApiOperation(value="6-01-2 \u67e5\u8be2\u8ba2\u5355\u4fe1\u606f", notes="\u652f\u4ed8\u540e\u67e5\u8be2\u8ba2\u5355\u72b6\u6001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="paymentNum", value="\u8ba2\u5355\u7f16\u53f7, 1\u5f85\u4ed8\u6b3e\uff0c2\u53d6\u6d88\u4ed8\u6b3e\uff0c3\u4ed8\u6b3e\u6210\u529f\uff0c4\u4ed8\u6b3e\u5931\u8d25\uff0c5\u5931\u8d25\u8d85\u65f6", dataType="String", required=true)})
    @GetMapping(value={"/order/status"})
    public Json<OrderStatusDTO> queryOrder(String paymentNum) {
        return ResultUtil.genSuccessResult((Object)this.payService.queryOrder(paymentNum));
    }

    @ApiOperation(value="6-01-3 [\u5df2\u5e9f\u5f03]\u7edf\u4e00\u4e0b\u5355\uff0c\u5e76\u7ec4\u88c5\u6240\u9700\u652f\u4ed8\u53c2\u6570", notes="\u8bf7\u8c03\u75286-01-5\u521b\u5efa\u8ba2\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", dataType="Long", required=true), @ApiImplicitParam(name="payType", value="\u4ed8\u6b3e\u7c7b\u578b, 1:\u5fae\u4fe1\uff0c2\uff1a\u652f\u4ed8\u5b9d", allowableValues="1,2", required=true), @ApiImplicitParam(name="amount", value="\u652f\u4ed8\u91d1\u989d(\u91d1\u989d:\u5143)", required=true), @ApiImplicitParam(name="bizId", value="\u4e1a\u52a1id")})
    @PostMapping(value={"/order/money"})
    @Deprecated
    public Json<PaymentOrderDTO> payOrder(Long userId, Byte payType, @RequestParam(value="amount") BigDecimal amount, @RequestParam(value="bizId", required=false) Long bizId, HttpServletRequest request) {
        UserOrderParam param = new UserOrderParam();
        param.setUserId(userId);
        param.setPayType(payType);
        param.setAmount(amount);
        param.setBizId(bizId);
        param.setRequestIp(WebUtils.getIpAddr((HttpServletRequest)request));
        param.setOrderType(OrderTypeEnum.RED_PACKET.getCode());
        PaymentOrderDTO order = this.paymentOrderFactory.build(param);
        if (order == null) {
            return ResultUtil.genFailedResult((String)"\u4e0b\u5355\u5931\u8d25,\u8bf7\u7a0d\u540e\u5c1d\u8bd5");
        }
        return ResultUtil.genSuccessResult((Object)order);
    }

    @ApiOperation(value="6-01-4 \u5fae\u4fe1APP\u652f\u4ed8\u540e\uff0c\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c", notes="\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c(\u53ea\u9002\u7528\u4e8e\u67e5\u8be2\u5fae\u4fe1\u652f\u4ed8\u7ed3\u679c)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="paymentNum", value="\u8ba2\u5355\u7f16\u53f7, \u8fd4\u56de\u7684\u72b6\u6001\u503c:1\u5f85\u4ed8\u6b3e\uff0c2\u53d6\u6d88\u4ed8\u6b3e\uff0c3\u4ed8\u6b3e\u6210\u529f\uff0c4\u4ed8\u6b3e\u5931\u8d25\uff0c5\u5931\u8d25\u8d85\u65f6", dataType="String", required=true)})
    @GetMapping(value={"/order/wxStatus"})
    public Json<OrderStatusDTO> queryWxOrderStatus(String paymentNum) {
        return ResultUtil.genSuccessResult((Object)this.payService.queryOrderStatus(paymentNum, PayTypeEnum.WX_PAY.getType()));
    }

    @ApiOperation(value="6-01-5 \u521b\u5efa\u9884\u4ed8\u8ba2\u5355", notes="\u89e6\u53d1\u652f\u4ed8\uff0c\u521b\u5efa\u7528\u6237\u8ba2\u5355\u3002\u524d\u7aef\u901a\u8fc7\u8fd4\u56de\u7684\u8ba2\u5355\u7f16\u53f7\u8f6e\u8be2\u8ba2\u5355\u5f53\u524d\u72b6\u6001\u8fdb\u884c\u540e\u7eed\u5904\u7406")
    @PostMapping(value={"/order/create"})
    public ResponseJson<PaymentOrderDTO> createPayOrder(@Valid @RequestBody UserOrderParam param, HttpServletRequest request) {
        param.setRequestIp(WebUtils.getIpAddr((HttpServletRequest)request));
        PaymentOrderDTO order = this.paymentOrderFactory.build(param);
        if (order == null) {
            return ResponseJson.badReqeuset((String)"\u4f60\u5df2\u6210\u529f\u6fc0\u6d3bVIP,\u8bf7\u52ff\u91cd\u590d\u8d2d\u4e70").build();
        }
        return ResponseJson.ok((Object)order);
    }
}

