/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.controller.facade;

import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.domain.PaymentOrderMapper;
import com.bxm.localnews.payment.dto.PaymentOrderInfoDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"6-50 [\u5185\u90e8\u63a5\u53e3]\u652f\u4ed8\u76f8\u5173\u53c2\u6570\u5bf9\u5916\u63d0\u4f9b"})
@RequestMapping(value={"facade/payment/pay"})
@RestController
public class PayFacadeController {
    private static final Logger log = LoggerFactory.getLogger(PayFacadeController.class);
    @Autowired
    private PayProperties payProperties;
    @Autowired
    private PaymentOrderMapper paymentOrderMapper;

    @ApiOperation(value="6-50-1 \u83b7\u53d6vip\u7684\u76f8\u5173\u4fe1\u606f")
    @GetMapping(value={"getVipInfo"})
    public ResponseEntity<PayProperties> getVipInfo() {
        return ResponseEntity.ok((Object)this.payProperties);
    }

    @ApiOperation(value="6-50-2 \u6839\u636e\u8ba2\u5355\u53f7\u83b7\u53d6\u6d41\u6c34\u4fe1\u606f")
    @GetMapping(value={"getPaymentNumByOrderSn"})
    public ResponseEntity<PaymentOrderInfoDTO> getPaymentNumByOrderSn(@RequestParam(value="orderSn") String orderNo, @RequestParam(value="status", required=false) Integer status) {
        if (Objects.isNull(status)) {
            status = PaymentStatusEnum.SUCCEED.getType().intValue();
        }
        return ResponseEntity.ok((Object)this.paymentOrderMapper.getByOrderSn(orderNo, status));
    }
}

