/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.controller.facade;

import com.bxm.localnews.payment.dto.PaymentOrderDTO;
import com.bxm.localnews.payment.order.PaymentOrderFactory;
import com.bxm.localnews.payment.param.MerchantWithdrawParam;
import com.bxm.localnews.payment.param.RefundParam;
import com.bxm.localnews.payment.param.UserOrderFacadeParam;
import com.bxm.localnews.payment.pay.WithdrawProxySerivce;
import com.bxm.localnews.payment.service.PaymentWithdrawAccountService;
import com.bxm.localnews.payment.vo.WithdrawAccountVO;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"6-91 \u652f\u4ed8\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"facade/withdraw/payment"})
public class PaymentFacadeController {
    private static final Logger log = LoggerFactory.getLogger(PaymentFacadeController.class);
    private final PaymentWithdrawAccountService paymentWithdrawAccountService;
    private final PaymentOrderFactory paymentOrderFactory;
    private final WithdrawProxySerivce withdrawProxySerivce;

    @ApiOperation(value="6-91-01 \u652f\u4ed8\u76f8\u5173\u8d26\u53f7\u4fe1\u606f", notes="\u652f\u4ed8\u76f8\u5173\u8d26\u53f7\u4fe1\u606f")
    @GetMapping(value={"/paymentAccount"})
    public ResponseEntity<WithdrawAccountVO> paymentAccount(@RequestParam(value="type") Byte type, @RequestParam(value="userId") Long userId) {
        Optional account = this.paymentWithdrawAccountService.getPaymentAccount(type, userId);
        return account.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.ok((Object)new WithdrawAccountVO()));
    }

    @ApiOperation(value="6-91-02 \u521b\u5efa\u9884\u4ed8\u8ba2\u5355", notes="\u6839\u636e\u8ba2\u5355\u4fe1\u606f\u521b\u5efa\u652f\u4ed8\u8ba2\u5355\u8fd4\u56de \u4f9b\u5185\u90e8\u4f7f\u7528 \u5982\u7528\u6237\u70b9\u51fb\u4e0b\u5355\uff0c\u8ba2\u5355\u6a21\u5757\u751f\u6210\u8ba2\u5355\u4e4b\u540e\uff0c\u8c03\u7528\u5f53\u524d\u63a5\u53e3\u751f\u6210\u652f\u4ed8\u4fe1\u606f")
    @PostMapping(value={"order/create"})
    public ResponseJson<PaymentOrderDTO> createPayOrder(@Valid @RequestBody UserOrderFacadeParam param) {
        return ResponseJson.ok((Object)this.paymentOrderFactory.build(param));
    }

    @ApiOperation(value="6-91-03 \u53d1\u8d77\u9000\u6b3e", notes="\u6839\u636e\u652f\u4ed8\u6d41\u6c34\u5355\u53f7\u53d1\u8d77\u9000\u6b3e \u4f9b\u5546\u6237\u6a21\u5757\u4f7f\u7528 \u5546\u5bb6\u5728\u540c\u610f\u8ba2\u5355\u9000\u6b3e\u65f6\u8c03\u7528\u5f53\u524d\u63a5\u53e3")
    @PostMapping(value={"refund"})
    public ResponseEntity<Message> refund(@RequestBody RefundParam param) {
        return ResponseEntity.ok((Object)this.paymentOrderFactory.submitRefund(param));
    }

    @ApiOperation(value="6-91-04 \u5546\u6237\u63d0\u73b0\u6253\u6b3e", notes="\u6839\u636e\u8bf7\u6c42\u7684\u8d26\u53f7\u4fe1\u606f\uff0c\u76f4\u63a5\u7ed9\u5bf9\u5e94\u7684\u652f\u4ed8\u5b9d\u8d26\u53f7 or \u5fae\u4fe1\u8d26\u53f7\u6253\u6b3e")
    @PostMapping(value={"merchantWithdraw"})
    public ResponseEntity<Message> merchantWithdraw(@RequestBody @Validated MerchantWithdrawParam param) {
        return ResponseEntity.ok((Object)this.withdrawProxySerivce.merchantWithdraw(param));
    }

    public PaymentFacadeController(PaymentWithdrawAccountService paymentWithdrawAccountService, PaymentOrderFactory paymentOrderFactory, WithdrawProxySerivce withdrawProxySerivce) {
        this.paymentWithdrawAccountService = paymentWithdrawAccountService;
        this.paymentOrderFactory = paymentOrderFactory;
        this.withdrawProxySerivce = withdrawProxySerivce;
    }
}

