package com.bxm.localnews.payment.facde.service;

import java.math.BigDecimal;

import com.bxm.localnews.payment.dto.OrderStatusDTO;
import com.bxm.localnews.payment.dto.PaymentOrderDTO;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.vo.Message;

/**
 * @author zhaoyadong 2019/1/2 14:08
 * @desc
 */
public interface PayService {

    /**
     * 用户购买vip
     *
     * @param userId    用户id
     * @param payType   支付类型
     * @param returnUrl 支付成功后跳转地址
     * @return 用户订单号和支付地址
     */
    PaymentOrderDTO addUserOrder(Long userId, Byte payType, String returnUrl);

    /**
     * 查询订单状态
     *
     * @param paymentNum
     * @return
     */
    OrderStatusDTO queryOrder(String paymentNum);

    /**
     * 更新支付订单状态
     *
     * @param paymentOrder 支付订单详情
     * @return 更新结果
     */
    Message modifyStatus(PaymentOrder paymentOrder);

    /**
     * 更新支付订单信息
     *
     * @param paymentOrder
     * @return
     */
    Message modifyPaymentOrderStatus(PaymentOrder paymentOrder);

    /**
     * 根据支付订单编号获取某一条支付订单的详细信息
     *
     * @param paymentNum 支付订单编号
     * @return 支付订单详细信息
     */
    PaymentOrder getPaymentOrderByPaymentNo(String paymentNum);

    /**
     * 下单: 金额由前端传入
     *
     * @param userId  用户id
     * @param payType 支付类型
     * @param amount  金额
     * @param bizId   业务id
     * @param ip      客户端ip
     * @return 预支付信息, 订单号z
     */
    PaymentOrderDTO createPayOrder(Long userId, Byte payType, BigDecimal amount, Long bizId, String ip);

    /**
     * 查询订单信息(主要是向微信查询订单信息)
     *
     * @param paymentNum
     * @param payType
     * @return
     */
    OrderStatusDTO queryOrderStatus(String paymentNum, Byte payType);
}
