package com.bxm.localnews.payment.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2018/12/27 21:05
 * @desc
 */
@ApiModel(description = "预支付订单信息")
public class PaymentOrderDTO {

    @ApiModelProperty(value = "付款链接")
    private String link;

    @ApiModelProperty(value = "付款订单编号")
    private String paymentNum;

    @ApiModelProperty(value = "预付款请求是否成功", hidden = true)
    private boolean success;

    public PaymentOrderDTO() {
    }

    public PaymentOrderDTO(String link, String paymentNum) {
        this.link = link;
        this.paymentNum = paymentNum;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getPaymentNum() {
        return paymentNum;
    }

    public void setPaymentNum(String paymentNum) {
        this.paymentNum = paymentNum;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }
}
