package com.bxm.localnews.payment.param;

import com.bxm.newidea.component.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author liujia
 * @date 2020-08-04 21:17
 **/
@ApiModel(description = "支付宝绑定账号参数")
@Data
public class AlipayAccountBindingParam extends BasicParam {

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("支付宝账号")
    private String account;

    @ApiModelProperty("绑定时的验证码")
    private String smsCode;

    @ApiModelProperty("支付宝中的真实姓名")
    private String realName;

    @ApiModelProperty("验证码对应的手机号码")
    private String phone;
}
