package com.bxm.localnews.payment.param;

import lombok.Builder;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 退款订单实体
 * @author liujia
 */
@ToString
@Data
@Builder
public class UserPayorderRefundBean {

    @Tolerate
    public UserPayorderRefundBean() {
    }

    /**
     * 主键
     */
    private Long id;

    /**
     * 付款订单ID
     */
    private Long orderId;

    /**
     * 退款订单编号
     */
    private String refundOrderNo;

    /**
     * 退款金额
     */
    private BigDecimal refundFee;

    /**
     * 退款备注
     */
    private String remark;

    /**
     * 第三方退款订单编号
     */
    private String refundTradeNo;

    /**
     * 退款状态(0：申请中，1：退款成功，2：退款失败)
     */
    private Byte status;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date modifyTime;

    /**
     * 操作人ID
     */
    private Long operatorId;

    /**
     * 退款操作结果
     */
    private String result;
}