package com.bxm.localnews.payment.vo;

import lombok.Data;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.Date;

@ToString
@Data
public class PaymentOrder {

    /**
     * id
     */
    private Long id;

    /**
     * 订单编号
     */
    private String paymentNum;

    /**
     * 业务id
     */
    private Long bizId;

    /**
     * 付款状态(1:待付款,2:取消付款,3:付款成功,4:付款失败,5:支付超时)
     */
    private Byte status;

    /**
     * 发起付款时间
     */
    private Date startTime;

    /**
     * 结束付款时间
     */
    private Date finishTime;

    /**
     * 付款金额
     */
    private BigDecimal amount;

    /**
     * 支付类型（1：微信，2：支付宝）
     */
    private Byte payType;

    /**
     * 发起支付的用户ID
     */
    private Long userId;

    /**
     * 支付反馈结果
     */
    private String result;

    /**
     * 发起支付的IP
     */
    private String clientIp;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 变更时间
     */
    private Date modifyTime;

    /**
     * 第三方交易订单号，在支付成功后写入
     * 用于退款和回溯
     */
    private String tradeNo;

    /**
     * 订单类型(购买订单买的什么东西)
     * {@link com.bxm.localnews.payment.constant.OrderTypeEnum}
     */
    private String orderType;

    /**
     * 下单渠道记录
     */
    private String channel;

    /**
     * 下单平台：android/ios/h5等
     */
    private Integer platform;

    /**
     * 最终收款的商户号ID
     */
    private String mchId;
}
