/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.proxy;

import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.service.PayModeService;
import com.bxm.localnews.payment.service.impl.DefaultPayModeService;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class PayProxyService {
    private Map<String, PayModeService> payModeMap;
    private PayModeService defaultPayModeService = new DefaultPayModeService();

    public void create(PaymentOrderDetail paymentOrderDetail) {
        this.getService(PayTypeEnum.getNameByType(paymentOrderDetail.getPayType())).create(paymentOrderDetail);
    }

    public void query(PaymentOrder paymentOrder, PayTypeEnum payType) {
        this.getService(payType.getName()).query(paymentOrder);
    }

    public String notifyPay(String data, PayTypeEnum payType) {
        return this.getService(payType.getName()).callBack(data);
    }

    private PayModeService getService(String payType) {
        PayModeService service = this.getPayModeMap().get(payType);
        if (service == null) {
            service = this.defaultPayModeService;
        }
        return service;
    }

    private Map<String, PayModeService> getPayModeMap() {
        if (null == this.payModeMap) {
            this.payModeMap = Maps.newHashMap();
            Collection payModeServices = SpringContextHolder.getBeans(PayModeService.class);
            for (PayModeService payModeService : payModeServices) {
                if (payModeService.support() == null) continue;
                this.payModeMap.put(payModeService.support().getName(), payModeService);
            }
        }
        return this.payModeMap;
    }
}

