/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.proxy;

import com.bxm.localnews.payment.config.WxPayProperties;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.service.BaseService;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxPayProxyService
extends BaseService {
    private WxPayService wxPayService;
    private WxPayProperties wxPayProperties;

    @Autowired
    public WxPayProxyService(WxPayService wxPayService, WxPayProperties wxPayProperties) {
        this.wxPayService = wxPayService;
        this.wxPayProperties = wxPayProperties;
    }

    public WxPayOrderNotifyResult parseOrderNotifyResult(String data) {
        try {
            return this.wxPayService.parseOrderNotifyResult(data);
        }
        catch (WxPayException e) {
            this.logger.error("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public WxPayOrderQueryResult queryOrder(String paymentNum) {
        try {
            return this.wxPayService.queryOrder(null, paymentNum);
        }
        catch (WxPayException e) {
            this.logger.error("\u67e5\u8be2\u8ba2\u5355[{}]\u5f02\u5e38: [{}]", (Object)paymentNum, (Object)e);
            return null;
        }
    }

    public WxPayAppOrderResult createOrder(PaymentOrderDetail paymentOrder) {
        try {
            WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = this.generateOrder((PaymentOrder)paymentOrder);
            return (WxPayAppOrderResult)this.wxPayService.createOrder(wxPayUnifiedOrderRequest);
        }
        catch (WxPayException e) {
            this.logger.error("\u5fae\u4fe1\u4e0b\u5355\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u539f\u56e0:{}", (Object)paymentOrder.getPaymentNum(), (Object)e.getMessage());
            this.logger.error("\u4e0b\u5355\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    private WxPayUnifiedOrderRequest generateOrder(PaymentOrder paymentOrder) {
        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();
        wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
        wxPayUnifiedOrderRequest.setOutTradeNo(paymentOrder.getPaymentNum());
        wxPayUnifiedOrderRequest.setBody(this.wxPayProperties.getBody());
        wxPayUnifiedOrderRequest.setSceneInfo(this.wxPayProperties.getSceneInfo());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)paymentOrder.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(paymentOrder.getClientIp());
        return wxPayUnifiedOrderRequest;
    }
}

