/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.service.impl;

import com.bxm.localnews.activity.service.RedPacketFacadeService;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.facde.service.PayService;
import com.bxm.localnews.payment.proxy.WxPayProxyService;
import com.bxm.localnews.payment.service.PayModeService;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.gexin.fastjson.JSON;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatPayModeService
extends BaseService
implements PayModeService {
    @Autowired
    private RedPacketFacadeService redPacketFacadeService;
    @Autowired
    private WxPayProxyService wxPayProxyService;
    @Autowired
    private PayService payService;

    @Override
    public PayTypeEnum support() {
        return PayTypeEnum.WX_PAY;
    }

    @Override
    public void create(PaymentOrderDetail paymentOrderDetail) {
        WxPayAppOrderResult result = this.wxPayProxyService.createOrder(paymentOrderDetail);
        paymentOrderDetail.setLink(JSON.toJSONString((Object)result));
    }

    @Override
    public void query(PaymentOrder paymentOrder) {
        WxPayOrderQueryResult result = this.wxPayProxyService.queryOrder(paymentOrder.getPaymentNum());
        if (!"SUCCESS".equals(result.getReturnCode()) || !"SUCCESS".equals(result.getResultCode())) {
            this.logger.error("\u67e5\u8be2\u8ba2\u5355[{}]\u5fae\u4fe1\u652f\u4ed8\u5931\u8d25", (Object)paymentOrder.getPaymentNum());
            return;
        }
        if ("SUCCESS".equals(result.getTradeState())) {
            this.afterPaySucceed(result, paymentOrder);
        } else {
            this.afterPayClose(result, paymentOrder);
        }
    }

    @Override
    public String callBack(String data) {
        WxPayOrderNotifyResult result = this.wxPayProxyService.parseOrderNotifyResult(data);
        String paymentNum = result.getOutTradeNo();
        PaymentOrder paymentOrder = this.payService.getPaymentOrderByPaymentNo(paymentNum);
        if (paymentOrder == null) {
            this.logger.error("\u63a5\u6536\u5230\u7684\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u53c2\u6570\u9519\u8bef,\u652f\u4ed8\u8ba2\u5355[{}]\u4e0d\u5b58\u5728", (Object)paymentNum);
            return null;
        }
        Integer amount = BaseWxPayRequest.yuanToFen((String)paymentOrder.getAmount().toString());
        if (amount.intValue() != result.getTotalFee().intValue()) {
            this.logger.error("\u652f\u4ed8\u8ba2\u5355\u652f\u4ed8\u91d1\u989d[{}]\u4e0e\u5fae\u4fe1\u8fd4\u56de\u7684\u8ba2\u5355\u603b\u91d1\u989d[{}]\u4e0d\u5339\u914d", (Object)amount, (Object)result.getTotalFee());
            return null;
        }
        if (!"SUCCESS".equals(result.getReturnCode()) || !"SUCCESS".equals(result.getResultCode())) {
            return null;
        }
        if (PaymentStatusEnum.WAIT.getType().equals(paymentOrder.getStatus())) {
            this.query(paymentOrder);
        }
        if (!PaymentStatusEnum.WAIT.getType().equals(paymentOrder.getStatus())) {
            this.logger.error("\u652f\u4ed8\u8ba2\u5355[{}]\u5df2\u5904\u7406\uff0c\u72b6\u6001\u4e3a\uff1a[{}]", (Object)paymentNum, (Object)paymentOrder.getStatus());
        }
        return "SUCCESS";
    }

    private void afterPayClose(WxPayOrderQueryResult result, PaymentOrder paymentOrder) {
        paymentOrder.setStatus(PaymentStatusEnum.UNDO.getType());
        paymentOrder.setFinishTime(DateUtils.parseDateNonStrict((String)result.getTimeEnd()));
        paymentOrder.setResult(result.getTradeState());
        this.payService.modifyPaymentOrderStatus(paymentOrder);
    }

    private void afterPaySucceed(WxPayOrderQueryResult result, PaymentOrder paymentOrder) {
        paymentOrder.setStatus(PaymentStatusEnum.SUCCEED.getType());
        paymentOrder.setFinishTime(DateUtils.parseDateNonStrict((String)result.getTimeEnd()));
        paymentOrder.setResult(result.getErrCodeDes());
        this.payService.modifyPaymentOrderStatus(paymentOrder);
        this.redPacketFacadeService.updateRedpacketActiveStatus(paymentOrder.getBizId(), paymentOrder.getPaymentNum(), Integer.valueOf(1));
    }
}

