/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.proxy;

import com.bxm.localnews.payment.constant.WithdrawTypeEnum;
import com.bxm.localnews.payment.service.WithdrawService;
import com.bxm.localnews.payment.service.impl.DefaultWithdrawService;
import com.bxm.localnews.payment.vo.WithdrawFlow;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class WithdrawProxySerivce {
    private Map<String, WithdrawService> withdrawMap;
    private WithdrawService defaultWithdrawService = new DefaultWithdrawService();

    public Message withdraw(WithdrawFlow withdrawFlow) {
        Message message = this.getService(WithdrawTypeEnum.getNameByChannel(withdrawFlow.getPayChannel())).withdraw(withdrawFlow);
        return message;
    }

    public Message queryWithdraw(WithdrawFlow withdrawFlow) {
        Message message = this.getService(WithdrawTypeEnum.getNameByChannel(withdrawFlow.getPayChannel())).queryWithdraw(withdrawFlow);
        return message;
    }

    private WithdrawService getService(String withdrawType) {
        WithdrawService service = this.getWithdrawMap().get(withdrawType);
        if (service == null) {
            service = this.defaultWithdrawService;
        }
        return service;
    }

    private Map<String, WithdrawService> getWithdrawMap() {
        if (null == this.withdrawMap) {
            this.withdrawMap = Maps.newHashMap();
            Collection withdrawServices = SpringContextHolder.getBeans(WithdrawService.class);
            for (WithdrawService withdrawService : withdrawServices) {
                if (withdrawService.support() == null) continue;
                this.withdrawMap.put(withdrawService.support().getName(), withdrawService);
            }
        }
        return this.withdrawMap;
    }
}

