/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.proxy;

import com.bxm.localnews.payment.config.WxPayProperties;
import com.bxm.localnews.payment.request.WxPayQueryWithdrawRequest;
import com.bxm.localnews.payment.request.WxPayWithdrawRequest;
import com.bxm.localnews.payment.result.QueryWithdrawResult;
import com.bxm.localnews.payment.result.WxWithdrawResult;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import com.thoughtworks.xstream.XStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WxWithdrawProxyService
extends WxPayServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(WxWithdrawProxyService.class);
    private final WxPayService wxPayService;
    private final WxPayService wxAppletPayService;
    private final WxPayProperties wxPayProperties;

    @Autowired
    public WxWithdrawProxyService(WxPayService wxPayService, WxPayService wxAppletPayService, WxPayProperties wxPayProperties) {
        this.wxPayService = wxPayService;
        this.wxAppletPayService = wxAppletPayService;
        this.wxPayProperties = wxPayProperties;
    }

    public byte[] postForBytes(String url, String requestStr, boolean useKey) {
        return new byte[0];
    }

    public String post(String url, String requestStr, boolean useKey) {
        return null;
    }

    private WxPayService getWxPayServiceByType(Byte withType) {
        if (null != withType && 2 == withType) {
            return this.wxAppletPayService;
        }
        return this.wxPayService;
    }

    public WxWithdrawResult transfers(WxPayWithdrawRequest request, Byte withType) throws WxPayException {
        WxPayService wxPayService = this.getWxPayServiceByType(withType);
        request.checkAndSign(wxPayService.getConfig());
        String url = wxPayService.getPayBaseUrl() + "/mmpaymkttransfers/promotion/transfers";
        String responseContent = wxPayService.post(url, request.toXML(), Boolean.TRUE.booleanValue());
        XStream xstream = new XStream();
        XStream.setupDefaultSecurity((XStream)xstream);
        xstream.processAnnotations(WxWithdrawResult.class);
        xstream.allowTypes(new Class[]{WxWithdrawResult.class});
        return (WxWithdrawResult)((Object)xstream.fromXML(responseContent));
    }

    public QueryWithdrawResult queryWithdraw(WxPayQueryWithdrawRequest request, Byte withType) throws WxPayException {
        WxPayService wxPayService = this.getWxPayServiceByType(withType);
        request.checkAndSign(wxPayService.getConfig());
        String url = this.getPayBaseUrl() + "/mmpaymkttransfers/gettransferinfo";
        String responseContent = super.post(url, request.toXML(), Boolean.TRUE.booleanValue());
        XStream xstream = new XStream();
        XStream.setupDefaultSecurity((XStream)xstream);
        xstream.processAnnotations(QueryWithdrawResult.class);
        xstream.allowTypes(new Class[]{QueryWithdrawResult.class});
        return (QueryWithdrawResult)((Object)xstream.fromXML(responseContent));
    }

    public WxPayOrderNotifyResult parseOrderNotifyResult(String data) {
        try {
            WxPayService wxPayService = this.getWxPayServiceByType(null);
            return wxPayService.parseOrderNotifyResult(data);
        }
        catch (WxPayException e) {
            log.error("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u5f02\u5e38:", (Throwable)e);
            return null;
        }
    }

    public WxPayOrderQueryResult queryOrder(String paymentNum, Byte withType) {
        try {
            WxPayService wxPayService = this.getWxPayServiceByType(withType);
            return wxPayService.queryOrder(null, paymentNum);
        }
        catch (WxPayException e) {
            log.error("\u67e5\u8be2\u8ba2\u5355[{}]\u5f02\u5e38: [{}]", (Object)paymentNum, (Object)e);
            return null;
        }
    }

    public WxPayAppOrderResult createOrder(PaymentOrderDetail paymentOrder, Byte withType) {
        try {
            WxPayService wxPayService = this.getWxPayServiceByType(withType);
            WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = this.generateOrder((PaymentOrder)paymentOrder);
            return (WxPayAppOrderResult)wxPayService.createOrder(wxPayUnifiedOrderRequest);
        }
        catch (WxPayException e) {
            log.error("\u5fae\u4fe1\u4e0b\u5355\u5931\u8d25\uff01\u8ba2\u5355\u53f7\uff1a{},\u539f\u56e0:{}", (Object)paymentOrder.getPaymentNum(), (Object)e.getMessage());
            log.error("\u4e0b\u5355\u5f02\u5e38\uff1a", (Throwable)e);
            return null;
        }
    }

    private WxPayUnifiedOrderRequest generateOrder(PaymentOrder paymentOrder) {
        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = new WxPayUnifiedOrderRequest();
        wxPayUnifiedOrderRequest.setDeviceInfo("WEB");
        wxPayUnifiedOrderRequest.setOutTradeNo(paymentOrder.getPaymentNum());
        wxPayUnifiedOrderRequest.setBody(this.wxPayProperties.getBody());
        wxPayUnifiedOrderRequest.setSceneInfo(this.wxPayProperties.getSceneInfo());
        wxPayUnifiedOrderRequest.setTotalFee(BaseWxPayRequest.yuanToFen((String)paymentOrder.getAmount().toString()));
        wxPayUnifiedOrderRequest.setSpbillCreateIp(paymentOrder.getClientIp());
        return wxPayUnifiedOrderRequest;
    }
}

