/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.payment.config.AlipayProperties;
import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.facde.service.PayService;
import com.bxm.localnews.payment.service.PayModeService;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliPayModeService
extends BaseService
implements PayModeService {
    private PayProperties payProperties;
    private BizConfigProperties bizConfigProperties;
    private AlipayProperties alipayProperties;
    private AlipayClient alipayClient;
    private PayService payService;

    @Autowired
    public AliPayModeService(PayProperties payProperties, BizConfigProperties bizConfigProperties, AlipayProperties alipayProperties, AlipayClient alipayClient, PayService payService) {
        this.payProperties = payProperties;
        this.bizConfigProperties = bizConfigProperties;
        this.alipayProperties = alipayProperties;
        this.alipayClient = alipayClient;
        this.payService = payService;
    }

    @Override
    public PayTypeEnum support() {
        return PayTypeEnum.ALI_PAY;
    }

    @Override
    public void create(PaymentOrderDetail paymentOrderDetail) {
        try {
            AlipayResponse alipayResponse = this.alipayClient.pageExecute((AlipayRequest)this.createWapPayRequest(paymentOrderDetail));
            paymentOrderDetail.setLink(alipayResponse.getBody());
            this.logger.info("\u652f\u4ed8\u5b9d\u9884\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)alipayResponse.getBody());
        }
        catch (AlipayApiException e) {
            this.logger.error("\u7528\u6237id{}\uff0c\u8ba2\u5355id{}\uff0c\u521b\u5efa\u652f\u4ed8\u5b9d\u9884\u652f\u4ed8\u4fe1\u606f\u5931\u8d25", (Object)paymentOrderDetail.getUserId(), (Object)paymentOrderDetail.getPaymentNum());
            this.logger.error("\u652f\u4ed8\u5b9d\u521b\u5efa\u9884\u652f\u4ed8\u4fe1\u606f\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    @Override
    public void query(PaymentOrder paymentOrder) {
        try {
            AlipayTradeQueryResponse alipayTradeQueryResponse = (AlipayTradeQueryResponse)this.alipayClient.execute((AlipayRequest)this.createTradeQueryRequest(paymentOrder.getPaymentNum()));
            this.logger.info("\u652f\u4ed8\u5b9d\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u7684\u4fe1\u606f\uff1a{}", (Object)alipayTradeQueryResponse.getBody());
        }
        catch (AlipayApiException e) {
            this.logger.error("\u652f\u4ed8\u5b9d\u8ba2\u5355[{}]\u67e5\u8be2\u76f8\u5173\u4fe1\u606f\u5931\u8d25", (Object)paymentOrder.getPaymentNum());
            this.logger.error("\u652f\u4ed8\u5b9d\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:{}", (Throwable)e);
        }
    }

    @Override
    public String callBack(String data) {
        Map map = (Map)JSONObject.parseObject((String)data, Map.class);
        String tradeStatus = (String)map.get("tradeStatus");
        String paymentNum = (String)map.get("outTradeNo");
        PaymentOrder paymentOrder = this.payService.getPaymentOrderByPaymentNo(paymentNum);
        if (paymentOrder == null) {
            this.logger.error("\u63a5\u6536\u5230\u7684\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u53c2\u6570\u9519\u8bef,\u652f\u4ed8\u8ba2\u5355[{}]\u4e0d\u5b58\u5728", (Object)paymentNum);
            return null;
        }
        if (!PaymentStatusEnum.WAIT.getType().equals(paymentOrder.getStatus())) {
            this.logger.error("\u652f\u4ed8\u8ba2\u5355[{}]\u5df2\u5904\u7406\uff0c\u72b6\u6001\u4e3a\uff1a[{}]", (Object)paymentNum, (Object)paymentOrder.getStatus());
            return null;
        }
        if (tradeStatus.equals("TRADE_FINISHED") || tradeStatus.equals("TRADE_SUCCESS")) {
            this.afterPaySucceed(map, paymentOrder);
        } else if (tradeStatus.equals("TRADE_CLOSED")) {
            this.afterPayClose(map, paymentOrder);
        }
        return null;
    }

    private void afterPayClose(Map<String, String> map, PaymentOrder paymentOrder) {
        paymentOrder.setStatus(PaymentStatusEnum.UNDO.getType());
        paymentOrder.setFinishTime(DateUtils.parseDateNonStrict((String)map.get("notifyTime")));
        this.payService.modifyStatus(paymentOrder);
    }

    private void afterPaySucceed(Map<String, String> map, PaymentOrder paymentOrder) {
        paymentOrder.setStatus(PaymentStatusEnum.SUCCEED.getType());
        paymentOrder.setFinishTime(DateUtils.parseDateNonStrict((String)map.get("notifyTime")));
        this.payService.modifyStatus(paymentOrder);
    }

    private AlipayTradeWapPayModel createWapPayModel(PaymentOrderDetail paymentOrderDetail) {
        this.logger.debug("payProperties:{}", (Object)this.payProperties);
        this.logger.debug("payProperties.vipPrice:{}", (Object)this.payProperties.getVipPrice());
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(paymentOrderDetail.getPaymentNum());
        model.setSubject(this.payProperties.getVipTitle());
        model.setTotalAmount(this.payProperties.getVipPrice().toString());
        model.setBody(this.payProperties.getVipDesc());
        model.setProductCode(this.alipayProperties.getProductCode());
        model.setTimeoutExpress(this.alipayProperties.getTimeoutExpress());
        return model;
    }

    private AlipayTradeWapPayRequest createWapPayRequest(PaymentOrderDetail paymentOrderDetail) {
        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        alipayRequest.setBizModel((AlipayObject)this.createWapPayModel(paymentOrderDetail));
        alipayRequest.setNotifyUrl(this.alipayProperties.getNotifyUrl());
        alipayRequest.setReturnUrl(this.bizConfigProperties.getH5ServerHost() + paymentOrderDetail.getReturnUrl() + "&paymentNum=" + paymentOrderDetail.getPaymentNum());
        return alipayRequest;
    }

    private AlipayTradeQueryModel createTradeQueryModel(String paymentNum) {
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setOutTradeNo(paymentNum);
        return model;
    }

    private AlipayTradeQueryRequest createTradeQueryRequest(String paymentNum) {
        AlipayTradeQueryRequest alipayTradeQueryRequest = new AlipayTradeQueryRequest();
        alipayTradeQueryRequest.setBizModel((AlipayObject)this.createTradeQueryModel(paymentNum));
        return alipayTradeQueryRequest;
    }
}

