/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.PushMsgIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.payment.config.WxPayProperties;
import com.bxm.localnews.payment.constant.WithdrawEnum;
import com.bxm.localnews.payment.constant.WithdrawTypeEnum;
import com.bxm.localnews.payment.constant.WxWithdrawEnum;
import com.bxm.localnews.payment.domain.WithdrawMapper;
import com.bxm.localnews.payment.proxy.WxWithdrawProxyService;
import com.bxm.localnews.payment.request.WxPayQueryWithdrawRequest;
import com.bxm.localnews.payment.request.WxPayWithdrawRequest;
import com.bxm.localnews.payment.result.QueryWithdrawResult;
import com.bxm.localnews.payment.result.WxWithdrawResult;
import com.bxm.localnews.payment.service.WithdrawService;
import com.bxm.localnews.payment.vo.WithdrawFlow;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatWithdrawService
implements WithdrawService {
    protected static final Logger logger = LoggerFactory.getLogger(WechatWithdrawService.class);
    private final WxWithdrawProxyService wxWithdrawProxyService;
    private final WxPayProperties wxPayProperties;
    private final WithdrawMapper withdrawMapper;
    private final UserAccountIntegrationService userAccountIntegrationService;
    private final PushMsgIntegrationService pushMsgIntegrationService;
    private final BizLogService bizLogService;
    private final DistributedLock distributedLock;
    private final SequenceCreater sequenceCreater;
    private final RedisStringAdapter redisStringAdapter;

    @Autowired
    public WechatWithdrawService(WxWithdrawProxyService wxWithdrawProxyService, WxPayProperties wxPayProperties, WithdrawMapper withdrawMapper, UserAccountIntegrationService userAccountIntegrationService, PushMsgIntegrationService pushMsgIntegrationService, BizLogService bizLogService, DistributedLock distributedLock, SequenceCreater sequenceCreater, RedisStringAdapter redisStringAdapter) {
        this.wxWithdrawProxyService = wxWithdrawProxyService;
        this.wxPayProperties = wxPayProperties;
        this.withdrawMapper = withdrawMapper;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.pushMsgIntegrationService = pushMsgIntegrationService;
        this.bizLogService = bizLogService;
        this.distributedLock = distributedLock;
        this.sequenceCreater = sequenceCreater;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public WithdrawTypeEnum support() {
        return WithdrawTypeEnum.WX_WITHDRAW;
    }

    @Override
    public Message withdraw(WithdrawFlow withdrawFlow) {
        Message message = Message.build();
        logger.info("\u63d0\u73b0\u7528\u6237[{}]\u7684\u63d0\u73b0\u8d26\u53f7\u4e3a\uff1a[{}]\uff0c\u63d0\u73b0\u91d1\u989d\u4e3a\uff1a[{}]", new Object[]{withdrawFlow.getUserId(), withdrawFlow.getPayAccount(), withdrawFlow.getAmount()});
        String requestId = this.sequenceCreater.nextLongId().toString();
        if (this.distributedLock.lock(withdrawFlow.getUserId() + withdrawFlow.getOrderNo(), requestId)) {
            WithdrawFlow wxWithdrawFlow = this.wxWithdraw(withdrawFlow);
            this.updateUserAccount(wxWithdrawFlow);
            this.distributedLock.unlock(withdrawFlow.getUserId() + withdrawFlow.getOrderNo(), requestId);
        }
        if (!"SUCCESS".equals(withdrawFlow.getRemark())) {
            logger.warn("\u7528\u6237\u63d0\u73b0\u5931\u8d25\uff0c\u63d0\u73b0\u4fe1\u606f[{}]", (Object)JSON.toJSONString((Object)withdrawFlow));
            message.setSuccess(false).setMessage("\u63d0\u73b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        } else {
            message.setSuccess(true).setMessage("");
        }
        return message;
    }

    @Override
    public Message queryWithdraw(WithdrawFlow withdrawFlow) {
        Message message = Message.build();
        this.queryWxWithdraw(withdrawFlow);
        return message;
    }

    private void updateUserAccount(WithdrawFlow wxWithdrawFlow) {
        if (wxWithdrawFlow != null) {
            this.userAccountIntegrationService.updateUserWithdraw(wxWithdrawFlow.getUserId(), wxWithdrawFlow.getAmount(), wxWithdrawFlow.getState());
        }
    }

    @Override
    public String callback(String data) {
        return null;
    }

    private WithdrawFlow wxWithdraw(WithdrawFlow withdrawFlow) {
        Date now = new Date();
        WxPayWithdrawRequest wxPayWithdrawRequest = this.generateWithdraw(withdrawFlow);
        try {
            WxWithdrawResult wxWithdrawResult = this.wxWithdrawProxyService.transfers(wxPayWithdrawRequest, withdrawFlow.getWithdrawType());
            logger.info("\u5fae\u4fe1\u8fd4\u56de\u4fe1\u606f[{}]", (Object)JSON.toJSONString((Object)((Object)wxWithdrawResult)));
            if (!"SUCCESS".equals(wxWithdrawResult.getReturnCode()) || !"SUCCESS".equals(wxWithdrawResult.getResultCode())) {
                withdrawFlow.setState(WithdrawEnum.FAIL_PAYMENT.getState());
                if ("V2_ACCOUNT_SIMPLE_BAN".equals(wxWithdrawResult.getErrCode())) {
                    logger.warn("\u8be5\u7528\u6237[{}]\u7684\u5fae\u4fe1\u672a\u5b9e\u540d\u8ba4\u8bc1", (Object)withdrawFlow.getUserId());
                    this.pushWithdrawFailMessage(withdrawFlow.getUserId());
                } else {
                    logger.warn("\u7528\u6237[{}]\u63d0\u73b0\u5931\u8d25", (Object)withdrawFlow.getUserId());
                }
                withdrawFlow.setRemark(wxWithdrawResult.getErrCode());
            } else {
                logger.info("\u7528\u6237[{}]\u63d0\u73b0\u6210\u529f\uff0c\u91d1\u989d\u4e3a\uff1a[{}]", (Object)withdrawFlow.getUserId(), (Object)withdrawFlow.getAmount());
                withdrawFlow.setState(WithdrawEnum.SUCCESS_PAYMENT.getState());
                withdrawFlow.setRemark(wxWithdrawResult.getResultCode());
                withdrawFlow.setPaymentNo(wxWithdrawResult.getPaymentNo());
                withdrawFlow.setPaymentTime(wxWithdrawResult.getPaymentTime());
                this.pushWithdrawSuccessMessage(withdrawFlow.getUserId(), withdrawFlow.getAmount());
                this.bizLogService.successWithdrawal(withdrawFlow.getUserId(), withdrawFlow.getAmount());
                this.deductCompanyAccount(withdrawFlow.getAmount());
            }
            withdrawFlow.setUpdateTime(now);
            this.withdrawMapper.updateWithdrawFlow(withdrawFlow);
            return withdrawFlow;
        }
        catch (WxPayException e) {
            logger.error("\u7528\u6237[{}]\u63d0\u73b0\u91d1\u989d\u4e3a[{}]\u53d1\u751f\u9519\u8bef\uff1a[{}]", new Object[]{withdrawFlow.getUserId(), withdrawFlow.getAmount(), e.getMessage()});
            logger.error("\u5fae\u4fe1\u63d0\u73b0\u53d1\u751f\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    private WithdrawFlow queryWxWithdraw(WithdrawFlow withdrawFlow) {
        Date now = new Date();
        withdrawFlow.setUpdateTime(now);
        WxPayQueryWithdrawRequest request = this.generateQueryWithdraw(withdrawFlow);
        try {
            QueryWithdrawResult result = this.wxWithdrawProxyService.queryWithdraw(request, withdrawFlow.getWithdrawType());
            logger.info("\u5fae\u4fe1\u8fd4\u56de\u4fe1\u606f[{}]", (Object)JSON.toJSONString((Object)((Object)result)));
            if (!"SUCCESS".equals(result.getReturnCode()) || !"SUCCESS".equals(result.getResultCode())) {
                withdrawFlow.setState(WithdrawEnum.FAIL_PAYMENT.getState());
                logger.info("\u7528\u6237[{}]\u67e5\u8be2\u8ba2\u5355[{}]\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25:\u8ba2\u5355\u4fe1\u606f\u72b6\u6001\uff1a[{}]", new Object[]{withdrawFlow.getUserId(), withdrawFlow.getPaymentNo(), result.getErrCode()});
            } else {
                logger.info("\u67e5\u8be2\u4f01\u4e1a\u4ed8\u6b3e\u4fe1\u606f\uff1a\u7528\u6237[{}]\u63d0\u73b0\u7684\u91d1\u989d\u4e3a\uff1a[{}], \u8f6c\u8d26\u72b6\u6001\uff1a[{}], \u5931\u8d25\u539f\u56e0\uff1a[{}]", new Object[]{withdrawFlow.getUserId(), withdrawFlow.getAmount(), result.getStatus(), result.getReason()});
                withdrawFlow.setState(WxWithdrawEnum.getWxWithdrawEnumByStatus(result.getStatus()).getState());
                withdrawFlow.setRemark(result.getResultCode());
                withdrawFlow.setPaymentNo(result.getPartnerTradeNo());
                withdrawFlow.setPaymentTime(result.getPaymentTime());
                this.withdrawMapper.updateWithdrawFlow(withdrawFlow);
            }
            return withdrawFlow;
        }
        catch (WxPayException e) {
            return null;
        }
    }

    private WxPayQueryWithdrawRequest generateQueryWithdraw(WithdrawFlow withdrawFlow) {
        WxPayQueryWithdrawRequest wxPayQueryWithdrawRequest = new WxPayQueryWithdrawRequest();
        wxPayQueryWithdrawRequest.setPartnerTradeNo(withdrawFlow.getOrderNo());
        return wxPayQueryWithdrawRequest;
    }

    private WxPayWithdrawRequest generateWithdraw(WithdrawFlow withdrawFlow) {
        WxPayWithdrawRequest wxPayWithdrawRequest = new WxPayWithdrawRequest();
        if (null == withdrawFlow.getWithdrawType() || 1 == withdrawFlow.getWithdrawType()) {
            wxPayWithdrawRequest.setAppid(this.wxPayProperties.getAppId());
        } else if (2 == withdrawFlow.getWithdrawType()) {
            wxPayWithdrawRequest.setAppid(this.wxPayProperties.getAppletAppId());
        }
        wxPayWithdrawRequest.setOpenId(withdrawFlow.getPayAccount());
        wxPayWithdrawRequest.setAmount(BaseWxPayRequest.yuanToFen((String)withdrawFlow.getAmount().toString()));
        wxPayWithdrawRequest.setCheckName("NO_CHECK");
        wxPayWithdrawRequest.setDesc(this.wxPayProperties.getDesc());
        wxPayWithdrawRequest.setPartnerTradeNo(withdrawFlow.getOrderNo());
        wxPayWithdrawRequest.setSpbillCreateIp(withdrawFlow.getClientIp());
        return wxPayWithdrawRequest;
    }

    private void pushWithdrawFailMessage(Long userId) {
        String title = "\u60a8\u7684\u5fae\u4fe1\u53f7\u672a\u5b9e\u540d\u8ba4\u8bc1\uff0c\u63d0\u73b0\u5931\u8d25\uff0c\u8bf7\u5b9e\u540d\u8ba4\u8bc1\u540e\u518d\u63d0\u73b0\u3002";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.FAIL_WITHDRAW);
        PushMessage message = PushMessage.build();
        message.setTitle("\u901a\u77e5\u6d88\u606f");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.pushMsgIntegrationService.pushMsg(message);
    }

    private void pushWithdrawSuccessMessage(Long userId, BigDecimal amount) {
        String title = "\u60a8\u7684" + amount + "\u5143\u63d0\u73b0\u5df2\u6210\u529f\u6253\u6b3e\uff0c\u53ef\u5728\u5fae\u4fe1\u94b1\u5305\u5185\u67e5\u770b";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.SUCCESS_WITHDRAW);
        PushMessage message = PushMessage.build();
        message.setTitle("\u901a\u77e5\u6d88\u606f");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.pushMsgIntegrationService.pushMsg(message);
    }

    private void deductCompanyAccount(BigDecimal amount) {
        this.redisStringAdapter.decrement(this.getCompanyAmountKey(), amount.doubleValue());
    }

    private KeyGenerator getCompanyAmountKey() {
        return RedisConfig.COMPANY_REMAIN_AMOUNT.copy().appendKey((Object)"balance");
    }
}

