package com.bxm.localnews.payment.config;

import com.alipay.api.*;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

/**
 * @author zhaoyadong 2019/1/2 17:54
 * @desc
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(AlipayProperties.class)
@AllArgsConstructor
public class AliPayConfiguration {

    private final AlipayProperties alipayProperties;

    private final AlipayCertProperties alipayCertProperties;

    @Bean("alipayClient")
    public AlipayClient alipayClient() {
        AlipayClient alipayClient = new DefaultAlipayClient(alipayProperties.getGateWayUrl(), alipayProperties.getAppId(),
                alipayProperties.getRsaPrivateKey(), alipayProperties.getFormat(), alipayProperties.getCharset(),
                alipayProperties.getAlipayPublicKey(), alipayProperties.getSigntype());
        return alipayClient;
    }

    /**
     * 带证书的alipayClient
     * 使用的时候需要 {@link AlipayClient#certificateExecute} 的方式执行，因为资金类的必须用证书签名
     * 如果要调试支付宝支付，就将engine下alipay的相关文件放到本机的对应目录下，方可正确配置
     * 怎么copy 参数Dockerfile文件的Add命令
     * @return 带证书的Client
     */
    @Bean
    @Lazy
    public AlipayClient alipayCertClient() throws AlipayApiException {
        // 构造client
        CertAlipayRequest certAlipayRequest = new CertAlipayRequest();
        certAlipayRequest.setServerUrl(alipayCertProperties.getGateWayUrl());
        certAlipayRequest.setAppId(alipayCertProperties.getAppId());
        certAlipayRequest.setPrivateKey(alipayCertProperties.getPrivateKey());
        certAlipayRequest.setFormat(alipayCertProperties.getFormat());
        certAlipayRequest.setCharset(alipayCertProperties.getCharset());
        certAlipayRequest.setSignType(alipayCertProperties.getSignType());
        certAlipayRequest.setCertPath(alipayCertProperties.getCertPath());
        certAlipayRequest.setAlipayPublicCertPath(alipayCertProperties.getAlipayPublicCertPath());
        certAlipayRequest.setRootCertPath(alipayCertProperties.getRootCertPath());


        try {
            return new DefaultAlipayClient(certAlipayRequest);
        } catch(Exception e) {
            log.error("初始化alipayCertClient失败使用alipayClient()返回", e);
        }

        return alipayClient();
    }
}
