package com.bxm.localnews.payment.order.impl;

import com.bxm.localnews.activity.service.RedPacketFacadeService;
import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.order.OrderProcesser;
import com.bxm.localnews.payment.param.UserOrderParam;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * 口令红包订单的相关处理逻辑
 * @author liujia
 * @date 2020/05/09 11:30
 */
@Component
public class RedPacketOrderProcesser implements OrderProcesser {

    private final RedPacketFacadeService redPacketFacadeService;

    @Autowired
    public RedPacketOrderProcesser(RedPacketFacadeService redPacketFacadeService) {
        this.redPacketFacadeService = redPacketFacadeService;
    }

    @Override
    public OrderTypeEnum match() {
        return OrderTypeEnum.RED_PACKET;
    }

    @Override
    public Message preCheck(UserOrderParam param) {
        return null;
    }

    @Override
    public BigDecimal price(UserOrderParam param) {
        //口令红包的支付价格由前端传递，属于用户打款
        return BigDecimal.ZERO;
    }

    @Override
    public Message afterPayment(PaymentOrder paymentOrder) {
        //支付成功后更新口令红包状态
        redPacketFacadeService.updateRedpacketActiveStatus(paymentOrder.getBizId(),
                paymentOrder.getPaymentNum(),
                1);
        return Message.build();
    }

    @Override
    public Message afterRefund(PaymentOrder paymentOrder) {
        return null;
    }
}
