package com.bxm.localnews.payment.pay.callback.listener.impl;

import com.bxm.localnews.payment.dto.NotifyContext;
import com.bxm.localnews.payment.pay.callback.listener.CallbackListener;
import lombok.extern.slf4j.Slf4j;

/**
 * @author gonzo
 * @date 2020-09-01 16:16
 **/
@Slf4j
public abstract class AbstractCallbackListener implements CallbackListener {

    @Override
    public void callbackNotify(NotifyContext context) {

        if (!preCheck(context)) {
            return;
        }

        doCallbackNotify(context);
    }

    /**
     * 基本校验
     *
     * @param context
     * @return true 继续执行
     */
    protected boolean preCheck(NotifyContext context) {
        return true;
    }

    /**
     * 处理回调
     *
     * @param context 包含了支付订单信息、回调信息、是否回调成功等等的上下文信息
     */
    protected abstract void doCallbackNotify(NotifyContext context);

}
