package com.bxm.localnews.payment.pay.callback.listener.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.integration.MerchantIntegrationService;
import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.dto.NotifyContext;
import com.bxm.localnews.payment.vo.PaymentOrder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 商家VIP下单支付之后的回调处理
 *
 * @author gonzo
 * @date 2020-09-01 16:15
 **/
@Service
@Slf4j
public class MerchantVipPaymentCallbackListener extends AbstractCallbackListener {

    @Autowired
    private MerchantIntegrationService merchantIntegrationService;

    @Override
    protected boolean preCheck(NotifyContext context) {
        if (!context.isCallBackSuccess()) {
            return false;
        }

        // 判断支付的订单类型
        PaymentOrder order = context.getOrder();
        return Objects.nonNull(order) && Objects.equals(order.getOrderType(), OrderTypeEnum.MERCHANT_VIP.getCode());
    }

    @Override
    protected void doCallbackNotify(NotifyContext context) {
        PaymentOrder order = context.getOrder();
        log.info("商户购买权益信息[{}]", JSONObject.toJSONString(order));
        //回调商户订单信息
        merchantIntegrationService.paySuccessCallback(order.getOrderSn());
    }
}
