package com.bxm.localnews.payment.service;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.payment.dto.WithdrawDTO;
import com.bxm.localnews.payment.param.UserWithdrawParam;
import com.bxm.localnews.payment.param.UserWithdrawV2Param;
import com.bxm.localnews.payment.vo.UserWithdrawAccountInfoVO;
import com.bxm.newidea.component.vo.Message;

import java.math.BigDecimal;

/**
 * 用户提现相关服务接口
 *
 * @author zhaoyadong 2019/3/11 10:24
 */
public interface UserWithdrawService {

    /**
     * 用户发起提现
     *
     * @param userId
     * @param amount
     * @param basicParam basicParam
     * @param ip         客户端ip
     * @return
     * @deprecated {@link #execWithdraw(UserWithdrawParam)}
     */
    @Deprecated
    Message userWithdraw(Long userId, BigDecimal amount, String ip, BasicParam basicParam);

    /**
     * 小程序提现
     *
     * @param userId 用户id
     * @param openId 小程序的openId
     * @param amount 提现金额
     * @param devcId 设备号
     * @param ip     客户端ip
     * @return
     * @deprecated {@link #execWithdraw(UserWithdrawParam)}
     */
    @Deprecated
    Message appletUserWithdraw(Long userId, String openId, BigDecimal amount, String devcId, String ip);

    /**
     * 用户发起提现
     *
     * @param param 提现参数
     * @return 提现处理结果
     */
    Message execWithdraw(UserWithdrawParam param);

    /**
     * 获取用户的当前可提现列表,兼容历史逻辑，从用户模块中迁移到此处统一管理
     *
     * @param userId 用户ID
     * @return 用户的提现列表
     */
    WithdrawDTO getWithdrawOptions(Long userId);

    /**
     * 用户发起提现 需要提供具体的提现金额 支持微信，支付宝
     *
     * @param param 提现参数
     * @return 提现处理结果
     */
    Message withdrawV2(UserWithdrawV2Param param);

    /**
     * 用户发起提现前获取用户提现账户信息
     *
     * @param userId 用户id
     * @return 获取的信息
     */
    UserWithdrawAccountInfoVO getWithdrawAccountInfo(Long userId);
}
