package com.bxm.localnews.payment.timer;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.payment.config.WithdrawProperties;
import com.bxm.localnews.payment.service.MoneyChangeService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.google.common.collect.Lists;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class ControlCompanyAccountTask extends AbstractCronTask<String> {

    @Resource
    private WithdrawProperties withdrawProperties;

    @Resource
    private HttpClientService httpClientService;

    @Resource
    private MoneyChangeService moneyChangeService;

    @Override
    protected ReturnT<String> service(String param) {
        BigDecimal companyAccount = moneyChangeService.getCompanyAccount();
        BigDecimal limitAmount = new BigDecimal(5000);
        BigDecimal alarmAmount = new BigDecimal(2000);

        //账户余额少于2000时
        if (companyAccount.compareTo(alarmAmount) < 1) {
            alarmMessage();
            return ReturnT.SUCCESS;
        }

        //账户余额小于5000时
        if (companyAccount.compareTo(limitAmount) < 1) {
            limitMessage();
        }

        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "controlCompanyAccountTask";
    }

    @Override
    public String cron() {
        return "0 0/5 * * * ? *";
    }

    @Override
    public String description() {
        return "公司微信账户少于5000开始报警";
    }

    /**
     * 提醒账户余额少于5000
     */
    private void limitMessage() {
        StringBuilder content = new StringBuilder();
        content.append("@+86-15057101245 @+86-18767120507 公司账户余额少于5000");
        JSONObject text = new JSONObject();
        text.put("content", content);
        JSONObject at = new JSONObject();
        at.put("atMobiles", Lists.newArrayList("+86-15057101245", "+86-18767120507"));
        at.put("isAtAll", false);
        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);
        msg.put("at", at);
        String response = httpClientService.doPostJson(withdrawProperties.getRedPacketStatistics(), msg.toJSONString());
        log.debug("dingding response:{}", response);
    }

    /**
     * 提醒账户余额少于2000
     */
    private void alarmMessage() {
        StringBuilder content = new StringBuilder();
        content.append("@+86-15057101245 @+86-18767120507 公司账户余额少于2000");
        JSONObject text = new JSONObject();
        text.put("content", content);
        JSONObject at = new JSONObject();
        at.put("atMobiles", Lists.newArrayList("+86-15057101245", "+86-18767120507"));
        at.put("isAtAll", false);
        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);
        msg.put("at", at);
        String response = httpClientService.doPostJson(withdrawProperties.getRedPacketStatistics(), msg.toJSONString());
        log.debug("dingding response:{}", response);
    }

}
