package com.bxm.localnews.payment.withdraw;

import com.bxm.localnews.payment.WithdrwaStrategyEnum;
import com.bxm.newidea.component.vo.Message;

/**
 * 提现策略，判断用户如果进行某一种类型的提现，是否满足对应的条件
 * @author liujia
 * @date 2020/05/18 22:54
 */
public interface IWithdrawStrategy {
    /**
     * 当前接口支持的提现策略
     * @return 策略定义
     */
    WithdrwaStrategyEnum match();

    /**
     * 执行提现操作
     * @param context 提现请求上下文信息
     * @return 提现结果
     */
    Message execWithdraw(WithdrawContext context);

    /**
     * 当前提现策略，用户是否有机会
     * @param userId 用户ID
     * @return true表示仍然可以进此种类型的提现
     */
    default boolean hasTimes(Long userId) {
        return true;
    }
}
