package com.bxm.localnews.payment.withdraw;

import com.bxm.localnews.payment.constant.WithdrawTypeEnum;
import com.bxm.localnews.payment.dto.WithdrawOptionDTO;
import com.bxm.localnews.payment.param.UserWithdrawParam;
import com.bxm.localnews.vo.UserAuth;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 提现上下文信息
 *
 * @author liujia
 * @date 2020/05/18 21:23
 */
@Data
public class WithdrawContext {
    /**
     * 原始的提现请求参数
     */
    private final UserWithdrawParam originParam;

    /**
     * 提现金额的选项，在 {@link com.bxm.localnews.payment.withdraw.filter.BaseWithdrawFilter}中设置
     */
    private WithdrawOptionDTO withdrawOption;

    /**
     * 兼容历史逻辑，提供提现金额直接写入
     */
    private BigDecimal amount;

    /**
     * 如果是微信提现，则表示微信OID，兼容历史逻辑，如果未设置则从用户鉴权信息中获取
     * 如果是支付宝提现，则表示支付宝账号
     */
    private String withdrawAccount;

    /**
     * 如果是微信提现，则表示微信OID, 1：app的openId 2:公众号的openId （根据不同的openID获取不同的appId来提现）
     */
    private Byte openIdType;

    /**
     * 支付宝提现需要的真实姓名
     */
    private String realName;

    /**
     * 当前用户是否为风险用户，在 {@link com.bxm.localnews.payment.withdraw.filter.BaseWithdrawFilter}中设置
     */
    private boolean risk;

    /**
     * 提现记录ID
     */
    private Long withDrawId;

    /**
     * 提现类型id 支付宝 or 微信
     */
    private WithdrawTypeEnum withdrawType;

    public WithdrawContext(UserWithdrawParam originParam) {
        this.originParam = originParam;
    }

    public BigDecimal getAmount() {
        if (null != amount) {
            return amount;
        }
        if (null == withdrawOption) {
            return BigDecimal.ZERO;
        }
        return withdrawOption.getAmount();
    }

    public Long getUserId() {
        return originParam.getUserId();
    }

    public UserWithdrawParam getOriginParam() {
        return originParam;
    }
}
