package com.bxm.localnews.payment.withdraw.filter;

import com.bxm.localnews.payment.constant.WithdrawEnum;
import com.bxm.localnews.payment.domain.WithdrawMapper;
import com.bxm.localnews.payment.vo.WithdrawFlow;
import com.bxm.localnews.payment.withdraw.WithdrawContext;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 已经存在提现中的订单
 * @author liujia
 * @date 2020/05/18 21:57
 */
@Component
@Slf4j
public class ExistsOrderWithdrawFilter extends AbstractWithdrawFilter {

    private final WithdrawMapper withdrawMapper;

    @Autowired
    public ExistsOrderWithdrawFilter(WithdrawMapper withdrawMapper) {
        this.withdrawMapper = withdrawMapper;
    }

    @Override
    public Message run(WithdrawContext context) {
        WithdrawFlow lastWithdrawFlow = withdrawMapper.getUserLastWithdraw(context.getUserId());

        boolean existsOrder = lastWithdrawFlow != null
                && !(WithdrawEnum.SUCCESS_PAYMENT.getState().equals(lastWithdrawFlow.getState())
                || WithdrawEnum.FAIL_PAYMENT.getState().equals(lastWithdrawFlow.getState()));

        if (existsOrder) {
            log.warn("用户[{}]已存在正在提现的订单，不允许提现", context.getUserId());

            return Message.build(false, "你的提现金额正在审批中，请勿重复提现");
        }

        return Message.build();
    }
}
