package com.bxm.localnews.payment.order;

import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.param.UserOrderParam;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.vo.Message;

import java.math.BigDecimal;

/**
 * 订单处理器，进行具体的某一种订单的特有逻辑处理
 * @author liujia
 * @date 2020/05/08 14:30
 */
public interface OrderProcesser {

    /**
     * 匹配的订单类型
     * @return 订单类型枚举
     */
    OrderTypeEnum match();

    /**
     * 前置检查，判断用户是否可以下单
     * @param param 请求参数
     * @return 检查结果
     */
    Message preCheck(UserOrderParam param);

    /**
     * 订单价格，不同订单使用不同的价格策略
     * @param param 请求参数
     * @return 订单价格
     */
    BigDecimal price(UserOrderParam param);

    /**
     * 支付成功后的处理逻辑
     * @param paymentOrder 支付订单
     * @return 处理结果
     */
    Message afterPayment(PaymentOrder paymentOrder);

    /**
     * 用户申请退款以后的处理业务流程
     * @param paymentOrder 支付订单
     * @return 处理结果
     */
    Message afterRefund(PaymentOrder paymentOrder);
}
