package com.bxm.localnews.payment.order;

import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.order.impl.DefaultOrderProcesser;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 订单处理器创建，统一管理不同订单的处理相关逻辑分支
 * @author liujia
 * @date 2020/05/09 11:18
 */
@Component
public class OrderProcesserManager {
    private Map<String, OrderProcesser> processerMap;

    private OrderProcesser defaultProcesser = new DefaultOrderProcesser();

    @Autowired
    public OrderProcesserManager(List<OrderProcesser> processers) {
        processerMap = Maps.newHashMap();
        if (processers != null) {
            processers.forEach(item -> processerMap.put(item.match().getCode(), item));
        }
    }

    public OrderProcesser get(String orderType) {
        OrderTypeEnum orderTypeEnum = OrderTypeEnum.getByCode(orderType);
        if (orderTypeEnum == null) {
            return defaultProcesser;
        }

        return processerMap.getOrDefault(orderType, defaultProcesser);
    }
}
