package com.bxm.localnews.payment.pay.callback.listener;

import com.bxm.localnews.payment.dto.NotifyContext;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

import static com.gexin.fastjson.JSON.toJSONString;

/**
 * @author gonzo
 * @date 2020-09-01 16:06
 **/
@Slf4j
@Component
@AllArgsConstructor
public class CallbackNotifier {

    private List<CallbackListener> listeners;

    public void callbackNotifyAll(NotifyContext context) {
        listeners.forEach(p -> {
            try {
                p.callbackNotify(context);
            } catch(Exception e) {
                log.error("调用: {} 的通知方法失败 context: {}", p.getClass(), toJSONString(context), e);
            }
        });

    }
}
