package com.bxm.localnews.payment.withdraw;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.OrderComparator;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 提现逻辑过滤链处理
 * @author liujia
 * @date 2020/05/18 21:10
 */
@Component
@Slf4j
public class WithdrawFilterChain {

    private List<WithdrawFilter> filters;

    @Autowired
    public WithdrawFilterChain(List<WithdrawFilter> filters) {
        OrderComparator.sort(filters);
        this.filters = filters;
    }

    public Message run(WithdrawContext context) {
        Message message = Message.build();

        for (WithdrawFilter filter : filters) {
            message = filter.run(context);
            if (null != message && !message.isSuccess()) {

                log.info("提现前置请求失败，失败原因：{}，请求参数：{}",
                        message.getLastMessage(),
                        JSON.toJSONString(context));

                return message;
            }
        }

        return message;
    }
}
