package com.bxm.localnews.payment.withdraw.strategy;

import com.bxm.localnews.payment.WithdrwaStrategyEnum;
import com.bxm.localnews.payment.withdraw.WithdrawContext;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static com.bxm.localnews.common.constant.RedisConfig.WITHDRAW_ONCE_RECORD;

/**
 * 一个用户仅可提现一次的处理逻辑
 * 历史曾经有此逻辑
 * @author liujia
 * @date 2020/05/18 21:20
 */
@Component
public class OnceWithdrawStrategy extends AbstractWithdrawStrategy {

    private final RedisSetAdapter redisSetAdapter;

    @Autowired
    public OnceWithdrawStrategy(RedisSetAdapter redisSetAdapter) {
        this.redisSetAdapter = redisSetAdapter;
    }

    @Override
    public WithdrwaStrategyEnum match() {
        return WithdrwaStrategyEnum.ONCE;
    }

    @Override
    public Message execWithdraw(WithdrawContext context) {
        Message message = directWithdraw(context);

        if (message.isSuccess()) {
            //记录用户提现
            redisSetAdapter.add(buildKey(context.getUserId()), context.getUserId());
        }


        return message;
    }

    private KeyGenerator buildKey(Long userId) {
        return WITHDRAW_ONCE_RECORD.copy().appendKey(userId % 10);
    }

    @Override
    public boolean hasTimes(Long userId) {
        //取非，不存在才有可提现次数
        return !redisSetAdapter.exists(buildKey(userId), userId);
    }
}
