/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.order.impl;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.UserActivationVipFacadeParam;
import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.domain.PaymentOrderMapper;
import com.bxm.localnews.payment.order.OrderProcesser;
import com.bxm.localnews.payment.param.PaymentOrderParam;
import com.bxm.localnews.payment.param.UserOrderParam;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WelfareVipOrderProcesser
implements OrderProcesser {
    private static final Logger log = LoggerFactory.getLogger(WelfareVipOrderProcesser.class);
    private final PayProperties payProperties;
    private final UserIntegrationService userIntegrationService;
    private final PaymentOrderMapper paymentOrderMapper;

    @Override
    public OrderTypeEnum match() {
        return OrderTypeEnum.WELFARE_VIP;
    }

    @Override
    public Message preCheck(UserOrderParam param) {
        if (Objects.isNull(param.getUserId())) {
            log.warn("\u7528\u6237id\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4e0b\u5355");
            return Message.build((boolean)false, (String)"\u7528\u6237id\u4e0d\u5b58\u5728");
        }
        UserInfoDTO userInfoDTO = this.userIntegrationService.getUserFromRedisDB(param.getUserId());
        if (Objects.isNull(userInfoDTO)) {
            log.warn("\u7528\u6237id: {} \u5bf9\u5e94\u7684\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4e0b\u5355", (Object)param.getUserId());
            return Message.build((boolean)false, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(userInfoDTO.getIsVip(), 1)) {
            return Message.build((boolean)false, (String)"\u60a8\u5df2\u662fVIP\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u5355");
        }
        PaymentOrderParam paymentOrderParam = new PaymentOrderParam();
        paymentOrderParam.setUserId(param.getUserId());
        paymentOrderParam.setOrderType(OrderTypeEnum.WELFARE_VIP.getCode());
        paymentOrderParam.setStatus(Byte.valueOf((byte)3));
        List paymentOrders = this.paymentOrderMapper.selectUserOrder(paymentOrderParam);
        if (!CollectionUtils.isEmpty((Collection)paymentOrders)) {
            return Message.build((boolean)false, (String)"\u5df2\u7ecf\u8d2d\u4e70VIP\u7684\u6210\u529f\u8ba2\u5355\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u5355");
        }
        return Message.build();
    }

    @Override
    public BigDecimal price(UserOrderParam param) {
        return this.payProperties.getWelfareVipPrice();
    }

    @Override
    public Message afterPayment(PaymentOrder paymentOrder) {
        log.debug("\u7528\u6237\u8d2d\u4e70\u6fc0\u6d3bVIP\uff0c\u5bf9\u5e94\u8ba2\u5355\uff1a{}", (Object)paymentOrder);
        UserActivationVipFacadeParam param = new UserActivationVipFacadeParam();
        param.setChannel(paymentOrder.getChannel());
        param.setOrderId(paymentOrder.getId());
        param.setPlatformEnum(paymentOrder.getPlatform());
        param.setUserId(paymentOrder.getUserId());
        param.setVipCardId("1");
        return Message.build((boolean)this.userIntegrationService.activationVip(param));
    }

    @Override
    public Message afterRefund(PaymentOrder paymentOrder) {
        return null;
    }

    public WelfareVipOrderProcesser(PayProperties payProperties, UserIntegrationService userIntegrationService, PaymentOrderMapper paymentOrderMapper) {
        this.payProperties = payProperties;
        this.userIntegrationService = userIntegrationService;
        this.paymentOrderMapper = paymentOrderMapper;
    }
}

