/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.pay.alipay;

import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.request.AlipayFundTransOrderQueryRequest;
import com.alipay.api.request.AlipayFundTransUniTransferRequest;
import com.alipay.api.response.AlipayFundTransOrderQueryResponse;
import com.alipay.api.response.AlipayFundTransUniTransferResponse;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.payment.config.WithdrawProperties;
import com.bxm.localnews.payment.constant.WithdrawEnum;
import com.bxm.localnews.payment.constant.WithdrawTypeEnum;
import com.bxm.localnews.payment.domain.WithdrawMapper;
import com.bxm.localnews.payment.param.AlipayFundTransUniTransferParam;
import com.bxm.localnews.payment.param.AlipayFundTransUniTransferPayeeInfoParam;
import com.bxm.localnews.payment.param.MerchantWithdrawParam;
import com.bxm.localnews.payment.service.WithdrawService;
import com.bxm.localnews.payment.vo.WithdrawFlow;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliWithdrawServiceImpl
implements WithdrawService {
    private static final Logger log = LoggerFactory.getLogger(AliWithdrawServiceImpl.class);
    private final AlipayClient alipayCertClient;
    private final SequenceCreater sequenceCreater;
    private final DistributedLock distributedLock;
    private final WithdrawMapper withdrawMapper;
    private final UserAccountIntegrationService userAccountIntegrationService;
    private final WithdrawProperties withdrawProperties;

    @Override
    public WithdrawTypeEnum support() {
        return WithdrawTypeEnum.ALI_WITHDRAW;
    }

    @Override
    public Message withdraw(WithdrawFlow withdrawFlow) {
        log.info("\u63d0\u73b0\u7528\u6237[{}]\u7684\u63d0\u73b0\u8d26\u53f7\u4e3a\uff1a[{}]\uff0c\u63d0\u73b0\u91d1\u989d\u4e3a\uff1a[{}]", new Object[]{withdrawFlow.getUserId(), withdrawFlow.getPayAccount(), withdrawFlow.getAmount()});
        String requestId = this.sequenceCreater.nextLongId().toString();
        String key = withdrawFlow.getUserId() + withdrawFlow.getOrderNo();
        if (!this.distributedLock.lock(key, requestId)) {
            return Message.build((boolean)false, (String)"\u8bf7\u52ff\u9891\u7e41\u64cd\u4f5c");
        }
        Message message = this.doAlipayWithdraw(withdrawFlow);
        if (message.isSuccess()) {
            this.afterPay(withdrawFlow, WithdrawEnum.SUCCESS_PAYMENT.getState(), "");
            this.distributedLock.unlock(key, requestId);
        } else {
            this.afterPay(withdrawFlow, WithdrawEnum.FAIL_PAYMENT.getState(), message.getLastMessage());
        }
        if (!message.isSuccess()) {
            log.warn("\u7528\u6237: {}\u53d1\u8d77\u652f\u4ed8\u5b9d\u63d0\u73b0\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570: {}\u5931\u8d25\u4fe1\u606f: {}", new Object[]{withdrawFlow.getUserId(), JSON.toJSONString((Object)withdrawFlow), message.getMessages()});
        }
        return message;
    }

    @Override
    public Message merchantWithdraw(MerchantWithdrawParam param) {
        log.info("\u5546\u6237: {} \u53d1\u8d77\u63d0\u73b0\u6253\u6b3e \u8bf7\u6c42\u53c2\u6570: {}", (Object)param.getMerchantId(), (Object)JSON.toJSONString((Object)param));
        String requestId = this.sequenceCreater.nextLongId().toString();
        String key = StringUtils.join((Object[])new Serializable[]{param.getMerchantId(), param.getWithdrawNo()});
        if (!this.distributedLock.lock(key, requestId)) {
            return Message.build((boolean)false, (String)"\u8bf7\u52ff\u9891\u7e41\u64cd\u4f5c");
        }
        Message message = this.doAlipayWithdraw(param.getPayAccount(), param.getRealName(), param.getWithdrawNo(), param.getAmount(), "\u672c\u5730\u4e07\u4e8b\u901a\u5546\u5bb6\u63d0\u73b0");
        if (!message.isSuccess()) {
            log.warn("\u5546\u6237: {}\u53d1\u8d77\u652f\u4ed8\u5b9d\u63d0\u73b0\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570: {}\u5931\u8d25\u4fe1\u606f: {}", new Object[]{param.getMerchantId(), JSON.toJSONString((Object)param), JSON.toJSONString((Object)message)});
        }
        return message;
    }

    private Message updateUserAccount(WithdrawFlow withdrawFlow, Byte withdrawState) {
        if (withdrawFlow != null) {
            return this.userAccountIntegrationService.updateUserWithdraw(withdrawFlow.getUserId(), withdrawFlow.getAmount(), withdrawState);
        }
        return Message.build((boolean)false);
    }

    private Message doAlipayWithdraw(WithdrawFlow withdrawFlow) {
        return this.doAlipayWithdraw(withdrawFlow.getPayAccount(), withdrawFlow.getRealName(), withdrawFlow.getOrderNo(), withdrawFlow.getAmount(), "\u672c\u5730\u4e07\u4e8b\u901a\u7528\u6237\u63d0\u73b0");
    }

    private Message doAlipayWithdraw(String payAccount, String realName, String orderNo, BigDecimal amount, String orderTitle) {
        if (!Objects.equals(this.withdrawProperties.getRemitSwitch(), Boolean.TRUE)) {
            log.info("\u6253\u6b3e\u5f00\u5173\u5173\u95ed\uff0c\u539f\u63d0\u73b0\u4ef7\u683c: {} \u4fee\u6539\u63d0\u73b0\u4ef7\u683c\u4e3a0.1", (Object)amount);
            amount = BigDecimal.valueOf(0.1);
        }
        AlipayFundTransUniTransferRequest request = new AlipayFundTransUniTransferRequest();
        AlipayFundTransUniTransferPayeeInfoParam payeeInfoParam = new AlipayFundTransUniTransferPayeeInfoParam();
        payeeInfoParam.setIdentity(payAccount);
        payeeInfoParam.setIdentityType("ALIPAY_LOGON_ID");
        payeeInfoParam.setName(realName);
        AlipayFundTransUniTransferParam transUniTransferParam = new AlipayFundTransUniTransferParam();
        transUniTransferParam.setOutBizNo(orderNo);
        transUniTransferParam.setTransAmount(amount);
        transUniTransferParam.setProductCode("TRANS_ACCOUNT_NO_PWD");
        transUniTransferParam.setBizScene("DIRECT_TRANSFER");
        transUniTransferParam.setOrderTitle(orderTitle);
        transUniTransferParam.setPayeeInfo(payeeInfoParam);
        transUniTransferParam.setRemark(orderTitle);
        request.setBizContent(JSON.toJSONString((Object)transUniTransferParam));
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u53d1\u8d77\u652f\u4ed8\u5b9d\u63d0\u73b0\uff0c\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)request));
            }
            AlipayFundTransUniTransferResponse response = (AlipayFundTransUniTransferResponse)this.alipayCertClient.certificateExecute((AlipayRequest)request);
            if (log.isDebugEnabled()) {
                log.debug("\u53d1\u8d77\u652f\u4ed8\u5b9d\u63d0\u73b0\uff0c\u8fd4\u56de\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)response));
            }
            if (Objects.equals(response.getStatus(), "SUCCESS")) {
                return Message.build((boolean)true);
            }
            log.warn("\u8c03\u7528\u652f\u4ed8\u5b9d\u63d0\u73b0\u5931\u8d25\uff0cpayAccount: {}, realName: {}, orderNo: {}, amount: {}, transUniTransferParam: {}, response: {}", new Object[]{payAccount, realName, orderNo, amount, JSON.toJSONString((Object)transUniTransferParam), JSON.toJSONString((Object)response)});
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63d0\u73b0\u7533\u8bf7\u5931\u8d25\uff0cpayAccount: {}, realName: {}, orderNo: {}, amount: {}, transUniTransferParam: {}", new Object[]{payAccount, realName, orderNo, amount, JSON.toJSONString((Object)transUniTransferParam), e});
        }
        return Message.build((boolean)false, (String)"\u652f\u4ed8\u5b9d\u63d0\u73b0\u51fa\u73b0\u9519\u8bef");
    }

    private void afterPay(WithdrawFlow withdrawFlow, Byte state, String reason) {
        WithdrawFlow update = new WithdrawFlow();
        update.setId(withdrawFlow.getId());
        update.setRemark(reason);
        update.setState(state);
        this.withdrawMapper.updateWithdrawFlow(update);
        this.updateUserAccount(withdrawFlow, state);
    }

    @Override
    public Message queryWithdraw(WithdrawFlow withdrawFlow) {
        this.query(withdrawFlow);
        return Message.build();
    }

    private Message query(WithdrawFlow withdrawFlow) {
        Date now = new Date();
        withdrawFlow.setUpdateTime(now);
        AlipayFundTransOrderQueryRequest request = new AlipayFundTransOrderQueryRequest();
        HashMap query = Maps.newHashMap();
        query.put("out_biz_no", withdrawFlow.getOrderNo());
        request.setBizContent(JSON.toJSONString((Object)query));
        try {
            if (log.isDebugEnabled()) {
                log.debug("\u67e5\u8be2\u652f\u4ed8\u5b9d\u8ba2\u5355\u4fe1\u606f: \u8bf7\u6c42\u53c2\u6570{}", (Object)JSON.toJSONString((Object)request));
            }
            AlipayFundTransOrderQueryResponse response = (AlipayFundTransOrderQueryResponse)this.alipayCertClient.execute((AlipayRequest)request);
            if (log.isDebugEnabled()) {
                log.debug("\u67e5\u8be2\u652f\u4ed8\u5b9d\u8ba2\u5355\u4fe1\u606f: \u8fd4\u56de\u53c2\u6570{}", (Object)JSON.toJSONString((Object)response));
            }
            if (!Objects.equals(response.getStatus(), "SUCCESS")) {
                withdrawFlow.setState(WithdrawEnum.FAIL_PAYMENT.getState());
                log.warn("\u8c03\u7528\u652f\u4ed8\u5b9d\u63d0\u73b0\u5931\u8d25\uff0cwithdrawFlow: {}, response: {}", (Object)JSON.toJSONString((Object)withdrawFlow), (Object)JSON.toJSONString((Object)response));
                return Message.build((boolean)false, (String)response.getFailReason());
            }
            return Message.build((boolean)true);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u4ed8\u5b9d\u63d0\u73b0\u67e5\u8be2\u5931\u8d25, withdrawFlow: {}", (Object)JSON.toJSONString((Object)withdrawFlow), (Object)e);
            return Message.build((boolean)false, (String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    public String callback(String data) {
        return null;
    }

    public AliWithdrawServiceImpl(AlipayClient alipayCertClient, SequenceCreater sequenceCreater, DistributedLock distributedLock, WithdrawMapper withdrawMapper, UserAccountIntegrationService userAccountIntegrationService, WithdrawProperties withdrawProperties) {
        this.alipayCertClient = alipayCertClient;
        this.sequenceCreater = sequenceCreater;
        this.distributedLock = distributedLock;
        this.withdrawMapper = withdrawMapper;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.withdrawProperties = withdrawProperties;
    }
}

