/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.pay.callback.listener.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.integration.MerchantIntegrationService;
import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.dto.NotifyContext;
import com.bxm.localnews.payment.pay.callback.listener.impl.AbstractCallbackListener;
import com.bxm.localnews.payment.vo.PaymentOrder;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MerchantVipPaymentCallbackListener
extends AbstractCallbackListener {
    private static final Logger log = LoggerFactory.getLogger(MerchantVipPaymentCallbackListener.class);
    @Autowired
    private MerchantIntegrationService merchantIntegrationService;

    @Override
    protected boolean preCheck(NotifyContext context) {
        if (!context.isCallBackSuccess()) {
            return false;
        }
        PaymentOrder order = context.getOrder();
        return Objects.nonNull(order) && Objects.equals(order.getOrderType(), OrderTypeEnum.MERCHANT_VIP.getCode());
    }

    @Override
    protected void doCallbackNotify(NotifyContext context) {
        PaymentOrder order = context.getOrder();
        log.info("\u5546\u6237\u8d2d\u4e70\u6743\u76ca\u4fe1\u606f[{}]", (Object)JSONObject.toJSONString((Object)order));
        this.merchantIntegrationService.paySuccessCallback(order.getOrderSn());
    }
}

