/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.service.impl;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.payment.domain.CashFlowMapper;
import com.bxm.localnews.payment.domain.WithdrawMapper;
import com.bxm.localnews.payment.service.MoneyChangeService;
import com.bxm.localnews.payment.vo.MoneyChange;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MoneyChangeServiceImpl
implements MoneyChangeService {
    private static final Logger log = LoggerFactory.getLogger(MoneyChangeServiceImpl.class);
    @Resource
    private WithdrawMapper withdrawMapper;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private CashFlowMapper cashFlowMapper;
    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Override
    public MoneyChange changeMoneyStatisticsByHour(String startTime, String endTime) {
        int drawUser = this.cashFlowMapper.countDrawUser(startTime, endTime);
        Integer countRegUser = this.userIntegrationService.countRegUser(startTime, endTime);
        BigDecimal totalBounty = this.cashFlowMapper.totalBounty(startTime, endTime);
        int countNumber = this.withdrawMapper.countNumber(startTime, endTime);
        BigDecimal totalAmount = this.withdrawMapper.countWithdrawAmount(startTime, endTime);
        BigDecimal successAmount = this.withdrawMapper.countSuccessWithdrawAmount(startTime, endTime);
        Double companyAmount = (Double)this.redisStringAdapter.get(this.getCompanyAmountKey(), Double.class);
        return new MoneyChange(Integer.valueOf(drawUser), countRegUser, totalBounty, Integer.valueOf(countNumber), totalAmount, successAmount, companyAmount);
    }

    @Override
    public BigDecimal getCompanyAccount() {
        Double companyAmount = (Double)this.redisStringAdapter.get(this.getCompanyAmountKey(), Double.class);
        return BigDecimal.valueOf(companyAmount);
    }

    private KeyGenerator getCompanyAmountKey() {
        return RedisConfig.COMPANY_REMAIN_AMOUNT.copy().appendKey((Object)"balance");
    }
}

