/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.config.WithdrawProperties;
import com.bxm.localnews.payment.constant.WithdrawEnum;
import com.bxm.localnews.payment.constant.WithdrawTypeEnum;
import com.bxm.localnews.payment.domain.WithdrawMapper;
import com.bxm.localnews.payment.dto.WithdrawConfigDTO;
import com.bxm.localnews.payment.dto.WithdrawDTO;
import com.bxm.localnews.payment.dto.WithdrawOptionDTO;
import com.bxm.localnews.payment.param.UserWithdrawParam;
import com.bxm.localnews.payment.param.UserWithdrawV2Param;
import com.bxm.localnews.payment.service.PaymentWithdrawAccountService;
import com.bxm.localnews.payment.service.UserWithdrawService;
import com.bxm.localnews.payment.vo.UserWithdrawAccountInfoVO;
import com.bxm.localnews.payment.vo.WithdrawAccountVO;
import com.bxm.localnews.payment.vo.WithdrawFlow;
import com.bxm.localnews.payment.withdraw.IWithdrawStrategy;
import com.bxm.localnews.payment.withdraw.WithdrawContext;
import com.bxm.localnews.payment.withdraw.WithdrawFilterChain;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BasicParam;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class WithdrawServiceImpl
extends BaseService
implements UserWithdrawService {
    private final RedisStringAdapter redisStringAdapter;
    private final BizLogService bizLogService;
    private final DistributedLock distributedLock;
    private final PayProperties payProperties;
    private final WithdrawFilterChain withdrawFilterChain;
    private final WithdrawProperties withdrawProperties;
    private final UserAccountIntegrationService userAccountIntegrationService;
    private static final Map<String, IWithdrawStrategy> withdrawStrategyMap = Maps.newHashMap();
    private final IWithdrawStrategy normalWithdrawStrategy;
    private final WithdrawMapper withdrawMapper;
    private final PaymentWithdrawAccountService paymentWithdrawAccountService;
    private final List<IWithdrawStrategy> withdrawStrategyList;

    @PostConstruct
    public void init() {
        this.withdrawStrategyList.forEach(strategy -> withdrawStrategyMap.put(strategy.match().name(), (IWithdrawStrategy)strategy));
    }

    @Override
    public Message userWithdraw(Long userId, BigDecimal amount, String ip, com.bxm.localnews.common.vo.BasicParam basicParam) {
        UserWithdrawParam param = new UserWithdrawParam();
        param.merge((BasicParam)basicParam);
        param.setUserId(userId);
        param.setRequestIp(ip);
        WithdrawContext context = new WithdrawContext(param);
        context.setAmount(amount);
        return this.execWithdraw(context);
    }

    @Override
    public Message appletUserWithdraw(Long userId, String openId, BigDecimal amount, String devcId, String ip) {
        UserWithdrawParam param = new UserWithdrawParam();
        param.setUserId(userId);
        param.setRequestIp(ip);
        param.setPlatform(PlatformEnum.APPLET.getCode());
        param.setDevcId(devcId);
        WithdrawContext context = new WithdrawContext(param);
        context.setAmount(amount);
        context.setWithdrawAccount(openId);
        Message message = Message.build();
        if (amount.compareTo(new BigDecimal(1)) < 0) {
            return message.setSuccess(false).setMessage("\u63d0\u73b0\u91d1\u989d\u9700\u8981\u5927\u4e8e\u6216\u7b49\u4e8e1\u5143");
        }
        Double withdrawAmount = this.redisStringAdapter.increment(this.getWxMiniAppAmountKey(), amount.doubleValue());
        this.redisStringAdapter.expire(this.getWxMiniAppAmountKey(), (long)DateUtils.getCurSeconds());
        if (this.payProperties.getMiniAppLimitAmount().compareTo(BigDecimal.valueOf(withdrawAmount)) < 0) {
            return message.setSuccess(false).setMessage("\u4eca\u65e5\u5151\u6362\u5df2\u8fbe\u9650\u989d\uff0c\u8bf7\u660e\u65e5\u518d\u6765");
        }
        message = this.execWithdraw(context);
        if (Objects.isNull(message) || !message.isSuccess()) {
            this.redisStringAdapter.decrement(this.getWxMiniAppAmountKey(), amount.doubleValue());
        }
        return message;
    }

    private Message execWithdraw(WithdrawContext context) {
        Message message = this.preCheck(context.getOriginParam());
        if (!message.isSuccess()) {
            return message;
        }
        context.setWithdrawType(WithdrawTypeEnum.ALI_WITHDRAW);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u7528\u6237\u53d1\u8d77\u63d0\u73b0\uff0c\u63d0\u73b0\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)context));
        }
        String requestId = this.nextSequence().toString();
        String userIdStr = context.getUserId().toString();
        if (this.distributedLock.lock(userIdStr, requestId)) {
            message = this.withdrawFilterChain.run(context);
            if (null != message && message.isSuccess()) {
                IWithdrawStrategy withdrawStrategy = withdrawStrategyMap.getOrDefault(context.getWithdrawOption().getStargy(), this.normalWithdrawStrategy);
                this.logger.info("\u7528\u6237\u63d0\u73b0\u5bf9\u5e94\u7684\u63d0\u73b0\u7b56\u7565\uff1a{},\u63d0\u73b0\u53c2\u6570\uff1a{}", (Object)withdrawStrategy.match().name(), (Object)JSON.toJSONString((Object)context));
                message = withdrawStrategy.execWithdraw(context);
                if (message.isSuccess()) {
                    this.bizLogService.initiateWithdrawal(context.getUserId(), context.getAmount(), Integer.valueOf(context.getOriginParam().getPlatform()));
                }
            }
            this.distributedLock.unlock(userIdStr, requestId);
        } else {
            message = Message.build((boolean)false, (String)"\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u7528\u6237\u53d1\u8d77\u63d0\u73b0\uff0c\u63d0\u73b0\u7ed3\u679c\uff1a{},\u63d0\u73b0\u53c2\u6570\u4e3a\uff1a{}", (Object)message, (Object)JSON.toJSONString((Object)context));
        }
        return message;
    }

    @Override
    public Message execWithdraw(UserWithdrawParam param) {
        return this.execWithdraw(new WithdrawContext(param));
    }

    private Message preCheck(UserWithdrawParam param) {
        if (Objects.nonNull(param) && StringUtils.isNotBlank((CharSequence)param.getCurVer()) && com.bxm.newidea.component.tools.StringUtils.isLessThan((String)param.getCurVer(), (String)"3.5.0")) {
            this.logger.info("\u7528\u6237: {} \u53d1\u8d77\u4e86\u63d0\u73b0\u7533\u8bf7\uff0c\u4f46\u7248\u672c\u8fc7\u4f4e\u3002\u63d0\u793a\u5f00\u5173\uff1a{},\u8bf7\u6c42\u53c2\u6570: {}", new Object[]{param.getUserId(), this.withdrawProperties.getWithdrawOldVersionNoticeSwitch(), JSON.toJSONString((Object)param)});
            if (Boolean.TRUE.equals(this.withdrawProperties.getWithdrawOldVersionNoticeSwitch())) {
                return Message.build((boolean)false).setMessage(this.withdrawProperties.getWithdrawOldVersionNotice());
            }
        }
        return Message.build((boolean)true);
    }

    @Override
    public WithdrawDTO getWithdrawOptions(Long userId) {
        WithdrawDTO withdrawDTO = new WithdrawDTO();
        this.setOptions(withdrawDTO, userId);
        withdrawDTO.setAvailableCash(this.userAccountIntegrationService.getUserDrawableCash(userId));
        WithdrawFlow userLastWithdraw = this.withdrawMapper.getUserLastWithdraw(userId);
        if (userLastWithdraw != null && WithdrawEnum.FAIL_PAYMENT.getState().equals(userLastWithdraw.getState())) {
            if ("V2_ACCOUNT_SIMPLE_BAN".equals(userLastWithdraw.getRemark())) {
                withdrawDTO.setFailMsg("\u60a8\u7684\u5fae\u4fe1\u53f7\u672a\u5b9e\u540d\u8ba4\u8bc1\uff0c\u63d0\u73b0\u5931\u8d25\uff0c\u8bf7\u5b9e\u540d\u8ba4\u8bc1\u540e\u518d\u63d0\u73b0");
            } else {
                withdrawDTO.setFailMsg("\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        Optional<WithdrawAccountVO> paymentAccount = this.paymentWithdrawAccountService.getPaymentAccount((byte)1, userId);
        paymentAccount.ifPresent(withdrawAccountVO -> withdrawDTO.setAlipayAccount(withdrawAccountVO.getAccount()));
        if (StringUtils.isNotBlank((CharSequence)this.withdrawProperties.getWithdrawNote())) {
            withdrawDTO.setNote(this.withdrawProperties.getWithdrawNote());
            withdrawDTO.setNoteProtocol(this.withdrawProperties.getWithdrawNoteProtocol());
        }
        return withdrawDTO;
    }

    private void setOptions(WithdrawDTO withdrawDTO, Long userId) {
        List<Object> sourceOptions = this.withdrawProperties.getWithdrawOptions();
        sourceOptions = sourceOptions.stream().sorted(Comparator.comparing(WithdrawOptionDTO::getPriority)).sorted(Comparator.comparing(WithdrawOptionDTO::getIndex)).collect(Collectors.toList());
        ArrayList result = Lists.newArrayList();
        block0: for (int i = 0; i < sourceOptions.size(); ++i) {
            for (WithdrawOptionDTO withdrawOptionDTO : sourceOptions) {
                if (withdrawOptionDTO.getIndex() != i || !withdrawStrategyMap.get(withdrawOptionDTO.getStargy()).hasTimes(userId)) continue;
                result.add(withdrawOptionDTO);
                continue block0;
            }
        }
        List configList = result.stream().map(option -> WithdrawConfigDTO.builder().amount(option.getAmount()).withdrawId(option.getWithdrawId()).enableWithdraw(Boolean.valueOf(true)).withdrawNumber(Integer.valueOf(1)).build()).collect(Collectors.toList());
        withdrawDTO.setWithdrawConfigDTOList(configList);
    }

    private KeyGenerator getWxMiniAppAmountKey() {
        return RedisConfig.WEIXIN_MINI_APP_AMOUNT.copy().appendKey((Object)"balance");
    }

    @Override
    public Message withdrawV2(UserWithdrawV2Param param) {
        BigDecimal money = param.getMoney();
        if (money == null || money.doubleValue() <= 0.0) {
            return Message.build((boolean)false, (String)"\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        BigDecimal newMoney = money.setScale(2, 1);
        if (newMoney.doubleValue() <= 0.0) {
            return Message.build((boolean)false, (String)"\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0.01");
        }
        return this.newVersionUserWithdraw(param);
    }

    private Message newVersionUserWithdraw(UserWithdrawV2Param param) {
        UserWithdrawParam userWithdrawParam = new UserWithdrawParam();
        BeanUtils.copyProperties((Object)param, (Object)userWithdrawParam);
        WithdrawContext context = new WithdrawContext(userWithdrawParam);
        context.setAmount(param.getMoney());
        if (param.getType() == 1) {
            context.setWithdrawType(WithdrawTypeEnum.WX_WITHDRAW);
        } else {
            context.setWithdrawType(WithdrawTypeEnum.ALI_WITHDRAW);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u7528\u6237\u53d1\u8d77\u63d0\u73b0\uff0c\u63d0\u73b0\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)context));
        }
        String requestId = this.nextSequence().toString();
        String userIdStr = context.getUserId().toString();
        Message message = null;
        if (this.distributedLock.lock(userIdStr, requestId)) {
            message = this.withdrawFilterChain.run(context);
            if (null != message && message.isSuccess()) {
                IWithdrawStrategy withdrawStrategy = withdrawStrategyMap.getOrDefault(context.getWithdrawOption().getStargy(), this.normalWithdrawStrategy);
                this.logger.info("\u7528\u6237\u63d0\u73b0\u5bf9\u5e94\u7684\u63d0\u73b0\u7b56\u7565\uff1a{},\u63d0\u73b0\u53c2\u6570\uff1a{}", (Object)withdrawStrategy.match().name(), (Object)JSON.toJSONString((Object)context));
                message = withdrawStrategy.execWithdraw(context);
                if (message.isSuccess()) {
                    this.bizLogService.initiateWithdrawal(context.getUserId(), context.getAmount(), Integer.valueOf(context.getOriginParam().getPlatform()));
                }
            }
            this.distributedLock.unlock(userIdStr, requestId);
        } else {
            message = Message.build((boolean)false, (String)"\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u7528\u6237\u53d1\u8d77\u63d0\u73b0\uff0c\u63d0\u73b0\u7ed3\u679c\uff1a{},\u63d0\u73b0\u53c2\u6570\u4e3a\uff1a{}", (Object)message, (Object)JSON.toJSONString((Object)context));
        }
        return message;
    }

    @Override
    public UserWithdrawAccountInfoVO getWithdrawAccountInfo(Long userId) {
        UserWithdrawAccountInfoVO userWithdrawAccountInfoVO = new UserWithdrawAccountInfoVO();
        Optional<WithdrawAccountVO> paymentAccount = this.paymentWithdrawAccountService.getPaymentAccount((byte)1, userId);
        paymentAccount.ifPresent(withdrawAccountVO -> userWithdrawAccountInfoVO.setAlipayAccount(withdrawAccountVO.getAccount()));
        return userWithdrawAccountInfoVO;
    }

    public WithdrawServiceImpl(RedisStringAdapter redisStringAdapter, BizLogService bizLogService, DistributedLock distributedLock, PayProperties payProperties, WithdrawFilterChain withdrawFilterChain, WithdrawProperties withdrawProperties, UserAccountIntegrationService userAccountIntegrationService, IWithdrawStrategy normalWithdrawStrategy, WithdrawMapper withdrawMapper, PaymentWithdrawAccountService paymentWithdrawAccountService, List<IWithdrawStrategy> withdrawStrategyList) {
        this.redisStringAdapter = redisStringAdapter;
        this.bizLogService = bizLogService;
        this.distributedLock = distributedLock;
        this.payProperties = payProperties;
        this.withdrawFilterChain = withdrawFilterChain;
        this.withdrawProperties = withdrawProperties;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.normalWithdrawStrategy = normalWithdrawStrategy;
        this.withdrawMapper = withdrawMapper;
        this.paymentWithdrawAccountService = paymentWithdrawAccountService;
        this.withdrawStrategyList = withdrawStrategyList;
    }
}

