/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.timer;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.payment.config.WithdrawProperties;
import com.bxm.localnews.payment.service.MoneyChangeService;
import com.bxm.localnews.payment.vo.MoneyChange;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CompanyAccountTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(CompanyAccountTask.class);
    @Resource
    private WithdrawProperties withdrawProperties;
    @Resource
    private HttpClientService httpClientService;
    @Resource
    private MoneyChangeService moneyChangeService;

    protected ReturnT<String> service(String param) {
        Date now = new Date();
        Date beforeNow = DateUtils.addField((Date)now, (int)10, (int)-1);
        String startTime = DateUtils.formatDateHour((Date)beforeNow);
        String endTime = DateUtils.formatDateHour((Date)now);
        MoneyChange moneyChange = this.moneyChangeService.changeMoneyStatisticsByHour(startTime, endTime);
        StringBuilder content = new StringBuilder();
        content.append("------").append(beforeNow.getMonth() + 1).append("\u6708").append(beforeNow.getDate()).append("\u65e5").append(beforeNow.getHours()).append("\u65f6").append("------\n");
        content.append("\u8f6c\u76d8\u62bd\u5956\u4eba\u6570\uff1a[").append(moneyChange.getDrawNumber()).append("]\n");
        content.append("\u6ce8\u518c\u4eba\u6570\uff1a[").append(moneyChange.getCountRegUser()).append("]\n");
        content.append("\u65b0\u589e\u8d4f\u91d1\u603b\u989d\uff1a[").append(moneyChange.getTotalBounty().setScale(2)).append("]\n");
        content.append("\u53d1\u8d77\u63d0\u73b0\u4eba\u6570\uff1a[").append(moneyChange.getWithdrawNumber()).append("]\n");
        content.append("\u63d0\u73b0\u603b\u91d1\u989d\uff1a[").append(moneyChange.getWithdarawAmount().setScale(2)).append("]\n");
        content.append("\u6210\u529f\u63d0\u73b0\u91d1\u989d\uff1a[").append(moneyChange.getSuccessWithdrawAmount().setScale(2)).append("]\n");
        content.append("\u516c\u53f8\u8d26\u6237\u4f59\u989d\uff1a[").append(moneyChange.getCompanyAmount()).append("]");
        JSONObject text = new JSONObject();
        text.put("content", (Object)content);
        JSONObject msg = new JSONObject();
        msg.put("msgtype", (Object)"text");
        msg.put("text", (Object)text);
        String response = this.httpClientService.doPostJson(this.withdrawProperties.getRedPacketStatistics(), msg.toJSONString());
        log.debug("dingding response:{}", (Object)response);
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "companyAccountTask";
    }

    public String cron() {
        return "0 1 0/1 * * ? *";
    }

    public String description() {
        return "\u516c\u53f8\u5fae\u4fe1\u8d26\u6237\u6bcf\u5c0f\u65f6\u76f8\u5173\u4fe1\u606f\u7edf\u8ba1";
    }
}

