/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.timer;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.payment.config.WithdrawProperties;
import com.bxm.localnews.payment.service.MoneyChangeService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.google.common.collect.Lists;
import com.xxl.job.core.biz.model.ReturnT;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ControlCompanyAccountTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(ControlCompanyAccountTask.class);
    @Resource
    private WithdrawProperties withdrawProperties;
    @Resource
    private HttpClientService httpClientService;
    @Resource
    private MoneyChangeService moneyChangeService;

    protected ReturnT<String> service(String param) {
        BigDecimal companyAccount = this.moneyChangeService.getCompanyAccount();
        BigDecimal limitAmount = new BigDecimal(5000);
        BigDecimal alarmAmount = new BigDecimal(2000);
        if (companyAccount.compareTo(alarmAmount) < 1) {
            this.alarmMessage();
            return ReturnT.SUCCESS;
        }
        if (companyAccount.compareTo(limitAmount) < 1) {
            this.limitMessage();
        }
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "controlCompanyAccountTask";
    }

    public String cron() {
        return "0 0/5 * * * ? *";
    }

    public String description() {
        return "\u516c\u53f8\u5fae\u4fe1\u8d26\u6237\u5c11\u4e8e5000\u5f00\u59cb\u62a5\u8b66";
    }

    private void limitMessage() {
        StringBuilder content = new StringBuilder();
        content.append("@+86-15057101245 @+86-18767120507 \u516c\u53f8\u8d26\u6237\u4f59\u989d\u5c11\u4e8e5000");
        JSONObject text = new JSONObject();
        text.put("content", (Object)content);
        JSONObject at = new JSONObject();
        at.put("atMobiles", (Object)Lists.newArrayList((Object[])new String[]{"+86-15057101245", "+86-18767120507"}));
        at.put("isAtAll", (Object)false);
        JSONObject msg = new JSONObject();
        msg.put("msgtype", (Object)"text");
        msg.put("text", (Object)text);
        msg.put("at", (Object)at);
        String response = this.httpClientService.doPostJson(this.withdrawProperties.getRedPacketStatistics(), msg.toJSONString());
        log.debug("dingding response:{}", (Object)response);
    }

    private void alarmMessage() {
        StringBuilder content = new StringBuilder();
        content.append("@+86-15057101245 @+86-18767120507 \u516c\u53f8\u8d26\u6237\u4f59\u989d\u5c11\u4e8e2000");
        JSONObject text = new JSONObject();
        text.put("content", (Object)content);
        JSONObject at = new JSONObject();
        at.put("atMobiles", (Object)Lists.newArrayList((Object[])new String[]{"+86-15057101245", "+86-18767120507"}));
        at.put("isAtAll", (Object)false);
        JSONObject msg = new JSONObject();
        msg.put("msgtype", (Object)"text");
        msg.put("text", (Object)text);
        msg.put("at", (Object)at);
        String response = this.httpClientService.doPostJson(this.withdrawProperties.getRedPacketStatistics(), msg.toJSONString());
        log.debug("dingding response:{}", (Object)response);
    }
}

