/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.order;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.facade.UserFeignService;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.domain.PaymentOrderMapper;
import com.bxm.localnews.payment.dto.PaymentOrderDTO;
import com.bxm.localnews.payment.order.OrderProcesser;
import com.bxm.localnews.payment.order.OrderProcesserManager;
import com.bxm.localnews.payment.param.PayRefundParam;
import com.bxm.localnews.payment.param.PaymentRefundParam;
import com.bxm.localnews.payment.param.UserOrderParam;
import com.bxm.localnews.payment.pay.PayProxyService;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Exception.class})
public class PaymentOrderFactory {
    private static final Logger log = LoggerFactory.getLogger(PaymentOrderFactory.class);
    private final OrderProcesserManager orderProcesserManager;
    private final PayProxyService payProxyService;
    private final PaymentOrderMapper paymentOrderMapper;
    private final SequenceCreater sequenceCreater;
    private final RedisStringAdapter redisStringAdapter;
    private final UserFeignService userFeignService;
    private static long CACHE_EXPIRED_SECONDS = 21600L;

    @Autowired
    public PaymentOrderFactory(OrderProcesserManager orderProcesserManager, PayProxyService payProxyService, PaymentOrderMapper paymentOrderMapper, SequenceCreater sequenceCreater, RedisStringAdapter redisStringAdapter, UserFeignService userFeignService) {
        this.orderProcesserManager = orderProcesserManager;
        this.payProxyService = payProxyService;
        this.paymentOrderMapper = paymentOrderMapper;
        this.sequenceCreater = sequenceCreater;
        this.redisStringAdapter = redisStringAdapter;
        this.userFeignService = userFeignService;
    }

    public PaymentOrderDTO build(UserOrderParam param) {
        log.debug("\u521b\u5efa\u652f\u4ed8\u8ba2\u5355\uff0cinivterId{}\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param.getInviterId(), (Object)param);
        OrderProcesser processer = this.orderProcesserManager.get(param.getOrderType());
        Message message = processer.preCheck(param);
        if (message.isSuccess()) {
            this.fixConflictOrder(param);
            PaymentOrder order = this.createOrder(param, processer);
            PaymentOrderDetail orderDetail = new PaymentOrderDetail();
            BeanUtils.copyProperties((Object)order, (Object)orderDetail);
            orderDetail.setAuthCode(param.getWechatCode());
            orderDetail.setReturnUrl(param.getReturnUrl());
            this.payProxyService.create(orderDetail);
            this.paymentOrderMapper.insertSelective(order);
            this.saveOrderCache(order);
            if (StringUtils.isNotEmpty((CharSequence)param.getInviterId())) {
                this.userFeignService.bindInviteUserId(param.getUserId(), Long.valueOf(Long.parseLong(param.getInviterId().trim())));
            }
            PaymentOrderDTO paymentOrderDTO = new PaymentOrderDTO(orderDetail.getLink(), order.getPaymentNum());
            BeanUtils.copyProperties((Object)orderDetail, (Object)paymentOrderDTO);
            return paymentOrderDTO;
        }
        return null;
    }

    private void saveOrderCache(PaymentOrder order) {
        KeyGenerator key = RedisConfig.WEIXIN_ORDER_STATUS.copy().appendKey((Object)order.getPaymentNum());
        this.redisStringAdapter.set(key, (Object)order.getStatus(), CACHE_EXPIRED_SECONDS);
    }

    private String generatePaymentNum(Byte payType) {
        String prefix = PayTypeEnum.getNameByType(payType);
        return NidGeneratorUtil.getOrderNo((String)prefix);
    }

    private PaymentOrder createOrder(UserOrderParam param, OrderProcesser processer) {
        Date now = new Date();
        String paymentNum = this.generatePaymentNum(param.getPayType());
        PaymentOrder paymentOrder = new PaymentOrder();
        paymentOrder.setId(this.sequenceCreater.nextLongId());
        paymentOrder.setPaymentNum(paymentNum);
        paymentOrder.setStatus(PaymentStatusEnum.WAIT.getType());
        if (param.getAmount() == null) {
            paymentOrder.setAmount(processer.price(param));
        } else {
            paymentOrder.setAmount(param.getAmount());
        }
        paymentOrder.setPayType(param.getPayType());
        paymentOrder.setUserId(param.getUserId());
        paymentOrder.setBizId(param.getBizId());
        paymentOrder.setStartTime(now);
        paymentOrder.setCreateTime(now);
        paymentOrder.setClientIp(param.getRequestIp());
        paymentOrder.setChannel(param.getChnl());
        paymentOrder.setOrderType(processer.match().getCode());
        paymentOrder.setPlatform(Integer.valueOf(param.getPlatform()));
        return paymentOrder;
    }

    private void fixConflictOrder(UserOrderParam param) {
        PaymentOrder paymentOrder = this.paymentOrderMapper.getUserPaymentOrderByStatus(param.getUserId(), PaymentStatusEnum.WAIT.getType(), param.getOrderType());
        if (paymentOrder == null) {
            return;
        }
        paymentOrder.setStatus(PaymentStatusEnum.UNDO.getType());
        this.paymentOrderMapper.updateByPrimaryKey(paymentOrder);
    }

    public Message submitRefund(PayRefundParam payRefundParam) {
        if (null == payRefundParam || null == payRefundParam.getOrderId()) {
            return Message.build((boolean)false);
        }
        PaymentOrder paymentOrder = this.paymentOrderMapper.queryByOrderId(payRefundParam.getOrderId());
        if (paymentOrder == null) {
            log.info("\u63d0\u4ea4\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8ba2\u5355id\uff1a{}", (Object)paymentOrder.getId());
            return Message.build((boolean)false, (String)("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8ba2\u5355id\u4e3a\uff1a" + paymentOrder.getId()));
        }
        if (!Objects.equals(PaymentStatusEnum.SUCCEED.getType(), paymentOrder.getStatus()) && !Objects.equals(PaymentStatusEnum.REFUND_FAIL.getType(), paymentOrder.getStatus())) {
            log.info("\u63d0\u4ea4\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8ba2\u5355id\uff1a{}", (Object)paymentOrder.getId());
            return Message.build((boolean)false, (String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u9000\u6b3e");
        }
        PaymentRefundParam paymentRefundParam = new PaymentRefundParam();
        paymentRefundParam.setPayOrder(paymentOrder);
        paymentRefundParam.setFullAmount(Boolean.valueOf(true));
        return this.payProxyService.submitRefund(paymentRefundParam);
    }

    public String execRefundCallback(String request, PayTypeEnum payType) {
        return this.payProxyService.execRefundCallback(request, payType);
    }
}

