/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.order.impl;

import com.bxm.localnews.activity.service.VipFacadeService;
import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.order.OrderProcesser;
import com.bxm.localnews.payment.param.UserOrderParam;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LocalVipOrderProcesser
implements OrderProcesser {
    private final PayProperties payProperties;
    private final VipFacadeService vipFacadeService;

    @Autowired
    public LocalVipOrderProcesser(PayProperties payProperties, VipFacadeService vipFacadeService) {
        this.payProperties = payProperties;
        this.vipFacadeService = vipFacadeService;
    }

    @Override
    public OrderTypeEnum match() {
        return OrderTypeEnum.LOCAL_VIP;
    }

    @Override
    public Message preCheck(UserOrderParam param) {
        return Message.build((boolean)this.vipFacadeService.checkUserVip(param.getUserId()));
    }

    @Override
    public BigDecimal price(UserOrderParam param) {
        return this.payProperties.getVipPrice();
    }

    @Override
    public Message afterPayment(PaymentOrder paymentOrder) {
        return null;
    }

    @Override
    public Message afterRefund(PaymentOrder paymentOrder) {
        return null;
    }
}

