/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.order.impl;

import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.param.UserActivationVipFacadeParam;
import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.order.OrderProcesser;
import com.bxm.localnews.payment.param.UserOrderParam;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WelfareVipOrderProcesser
implements OrderProcesser {
    private static final Logger log = LoggerFactory.getLogger(WelfareVipOrderProcesser.class);
    private final PayProperties payProperties;
    private final UserIntegrationService userIntegrationService;

    @Autowired
    public WelfareVipOrderProcesser(PayProperties payProperties, UserIntegrationService userIntegrationService) {
        this.payProperties = payProperties;
        this.userIntegrationService = userIntegrationService;
    }

    @Override
    public OrderTypeEnum match() {
        return OrderTypeEnum.WELFARE_VIP;
    }

    @Override
    public Message preCheck(UserOrderParam param) {
        return Message.build();
    }

    @Override
    public BigDecimal price(UserOrderParam param) {
        return this.payProperties.getWelfareVipPrice();
    }

    @Override
    public Message afterPayment(PaymentOrder paymentOrder) {
        log.debug("\u7528\u6237\u8d2d\u4e70\u6fc0\u6d3bVIP\uff0c\u5bf9\u5e94\u8ba2\u5355\uff1a{}", (Object)paymentOrder);
        UserActivationVipFacadeParam param = new UserActivationVipFacadeParam();
        param.setChannel(paymentOrder.getChannel());
        param.setOrderId(paymentOrder.getId());
        param.setPlatformEnum(paymentOrder.getPlatform());
        param.setUserId(paymentOrder.getUserId());
        param.setVipCardId("1");
        return Message.build((boolean)this.userIntegrationService.activationVip(param));
    }

    @Override
    public Message afterRefund(PaymentOrder paymentOrder) {
        return null;
    }
}

