/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.pay;

import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.param.PaymentRefundParam;
import com.bxm.localnews.payment.pay.PayModeService;
import com.bxm.localnews.payment.pay.impl.DefaultPayModeServiceImpl;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PayProxyService {
    private static final Logger log = LoggerFactory.getLogger(PayProxyService.class);
    private Map<String, PayModeService> payModeMap;
    private PayModeService defaultPayModeService = new DefaultPayModeServiceImpl();

    public void create(PaymentOrderDetail paymentOrderDetail) {
        this.getService(PayTypeEnum.getNameByType(paymentOrderDetail.getPayType())).create(paymentOrderDetail);
    }

    public void query(PaymentOrder paymentOrder, PayTypeEnum payType) {
        this.getService(payType.getName()).query(paymentOrder);
    }

    public String notifyPay(String data, PayTypeEnum payType) {
        return this.getService(payType.getName()).callBack(data);
    }

    private PayModeService getService(String payType) {
        PayModeService service = this.getPayModeMap().get(payType);
        if (service == null) {
            service = this.defaultPayModeService;
        }
        return service;
    }

    public Message submitRefund(PaymentRefundParam param) {
        Preconditions.checkArgument((null != param ? 1 : 0) != 0);
        Preconditions.checkArgument((null != param.getPayOrder() ? 1 : 0) != 0);
        return this.obtainPayment(PayTypeEnum.getPayTypeEnum(param.getPayOrder().getPayType())).submitRefund(param);
    }

    public String execRefundCallback(String request, PayTypeEnum payType) {
        return this.obtainPayment(payType).execRefundCallback(request);
    }

    private PayModeService obtainPayment(PayTypeEnum payType) {
        PayModeService service = this.getPayModeMap().get(payType.getName());
        if (service == null) {
            log.error("\u8bf7\u6c42\u7684\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e3a\uff1a{}", (Object)payType);
            return this.defaultPayModeService;
        }
        return service;
    }

    private Map<String, PayModeService> getPayModeMap() {
        if (null == this.payModeMap) {
            this.payModeMap = Maps.newHashMap();
            Collection payModeServices = SpringContextHolder.getBeans(PayModeService.class);
            for (PayModeService payModeService : payModeServices) {
                if (payModeService.support() == null) continue;
                this.payModeMap.put(payModeService.support().getName(), payModeService);
            }
        }
        return this.payModeMap;
    }
}

