/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.pay.alipay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayObject;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.domain.AlipayTradeQueryModel;
import com.alipay.api.domain.AlipayTradeRefundModel;
import com.alipay.api.domain.AlipayTradeWapPayModel;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.payment.config.AlipayProperties;
import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.param.PaymentRefundParam;
import com.bxm.localnews.payment.pay.PayModeService;
import com.bxm.localnews.payment.pay.PaymentOrderService;
import com.bxm.localnews.payment.pay.impl.AbstractPayModeService;
import com.bxm.localnews.payment.request.AlipayNotifyResult;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliPayModeServiceImpl
extends AbstractPayModeService
implements PayModeService {
    private static final Logger log = LoggerFactory.getLogger(AliPayModeServiceImpl.class);
    private PayProperties payProperties;
    private BizConfigProperties bizConfigProperties;
    private AlipayProperties alipayProperties;
    private AlipayClient alipayClient;
    private PaymentOrderService payService;
    private static final String SUCCESS_CODE = "10000";

    @Autowired
    public AliPayModeServiceImpl(PayProperties payProperties, BizConfigProperties bizConfigProperties, AlipayProperties alipayProperties, AlipayClient alipayClient, PaymentOrderService payService) {
        this.payProperties = payProperties;
        this.bizConfigProperties = bizConfigProperties;
        this.alipayProperties = alipayProperties;
        this.alipayClient = alipayClient;
        this.payService = payService;
    }

    @Override
    public PayTypeEnum support() {
        return PayTypeEnum.ALI_PAY;
    }

    @Override
    public void create(PaymentOrderDetail paymentOrderDetail) {
        try {
            AlipayResponse alipayResponse = this.alipayClient.pageExecute((AlipayRequest)this.createWapPayRequest(paymentOrderDetail));
            paymentOrderDetail.setLink(alipayResponse.getBody());
            this.logger.info("\u652f\u4ed8\u5b9d\u9884\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)alipayResponse.getBody());
        }
        catch (AlipayApiException e) {
            this.logger.error("\u7528\u6237id{}\uff0c\u8ba2\u5355id{}\uff0c\u521b\u5efa\u652f\u4ed8\u5b9d\u9884\u652f\u4ed8\u4fe1\u606f\u5931\u8d25", new Object[]{paymentOrderDetail.getUserId(), paymentOrderDetail.getPaymentNum(), e});
        }
    }

    @Override
    public void query(PaymentOrder paymentOrder) {
        try {
            AlipayTradeQueryResponse alipayTradeQueryResponse = (AlipayTradeQueryResponse)this.alipayClient.execute((AlipayRequest)this.createTradeQueryRequest(paymentOrder.getPaymentNum()));
            this.logger.info("\u652f\u4ed8\u5b9d\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u7684\u4fe1\u606f\uff1a{}", (Object)alipayTradeQueryResponse.getBody());
        }
        catch (AlipayApiException e) {
            this.logger.error("\u652f\u4ed8\u5b9d\u8ba2\u5355[{}]\u67e5\u8be2\u76f8\u5173\u4fe1\u606f\u5931\u8d25", (Object)paymentOrder.getPaymentNum(), (Object)e);
        }
    }

    @Override
    public String callBack(String data) {
        AlipayNotifyResult result = (AlipayNotifyResult)JSONObject.parseObject((String)data, AlipayNotifyResult.class);
        PaymentOrder paymentOrder = this.payService.getPaymentOrderByPaymentNo(result.getOutTradeNo());
        if (paymentOrder == null) {
            this.logger.error("\u63a5\u6536\u5230\u7684\u652f\u4ed8\u5b9d\u652f\u4ed8\u56de\u8c03\u53c2\u6570\u9519\u8bef,\u652f\u4ed8\u8ba2\u5355[{}]\u4e0d\u5b58\u5728", (Object)result.getOutTradeNo());
            return null;
        }
        if (PaymentStatusEnum.SUCCEED.getType().equals(paymentOrder.getStatus())) {
            this.logger.error("\u652f\u4ed8\u8ba2\u5355[{}]\u91cd\u590d\u5904\u7406\uff0c\u72b6\u6001\u4e3a\uff1a[{}]", (Object)result.getOutTradeNo(), (Object)paymentOrder.getStatus());
            return null;
        }
        if (!PaymentStatusEnum.WAIT.getType().equals(paymentOrder.getStatus())) {
            this.logger.warn("\u8ba2\u5355[{}]\u5f53\u524d\u72b6\u6001\u4e0d\u662f\u5f85\u4ed8\u6b3e\uff0c\u6b64\u60c5\u51b5\u662f\u5f02\u5e38\u72b6\u6001\uff0c\u8bf7\u6ce8\u610f\u4e1a\u52a1\u6d41\u7a0b\u548c\u903b\u8f91", (Object)paymentOrder.getPaymentNum());
        }
        paymentOrder.setTradeNo(result.getTradeNo());
        paymentOrder.setFinishTime(DateUtils.parseDateNonStrict((String)result.getNotifyTime()));
        if (StringUtils.equalsAny((CharSequence)result.getTradeStatus(), (CharSequence[])new CharSequence[]{"TRADE_FINISHED", "TRADE_SUCCESS"})) {
            paymentOrder.setStatus(PaymentStatusEnum.SUCCEED.getType());
            this.payService.modifyStatus(paymentOrder);
        } else if ("TRADE_CLOSED".equals(result.getTradeStatus())) {
            paymentOrder.setStatus(PaymentStatusEnum.UNDO.getType());
            this.payService.modifyStatus(paymentOrder);
        }
        return null;
    }

    private AlipayTradeWapPayModel createWapPayModel(PaymentOrderDetail paymentOrderDetail) {
        this.logger.debug("payProperties:{}", (Object)this.payProperties);
        this.logger.debug("payProperties.vipPrice:{}", (Object)this.payProperties.getVipPrice());
        AlipayTradeWapPayModel model = new AlipayTradeWapPayModel();
        model.setOutTradeNo(paymentOrderDetail.getPaymentNum());
        model.setSubject(this.payProperties.getVipTitle());
        model.setTotalAmount(this.payProperties.getVipPrice().toString());
        model.setBody(this.payProperties.getVipDesc());
        model.setProductCode(this.alipayProperties.getProductCode());
        model.setTimeoutExpress(this.alipayProperties.getTimeoutExpress());
        return model;
    }

    private AlipayTradeWapPayRequest createWapPayRequest(PaymentOrderDetail paymentOrderDetail) {
        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        alipayRequest.setBizModel((AlipayObject)this.createWapPayModel(paymentOrderDetail));
        alipayRequest.setNotifyUrl(this.alipayProperties.getNotifyUrl());
        if (StringUtils.isNotBlank((CharSequence)paymentOrderDetail.getReturnUrl())) {
            StringBuilder returnUrl = new StringBuilder();
            if (!StringUtils.startsWith((CharSequence)paymentOrderDetail.getReturnUrl(), (CharSequence)"http")) {
                returnUrl.append(this.bizConfigProperties.getH5ServerHost());
            }
            returnUrl.append(paymentOrderDetail.getReturnUrl());
            returnUrl.append("&paymentNum=");
            returnUrl.append("paymentOrderDetail.getPaymentNum()");
            alipayRequest.setReturnUrl(returnUrl.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u652f\u4ed8\u5b9d\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)alipayRequest));
        }
        return alipayRequest;
    }

    private AlipayTradeQueryModel createTradeQueryModel(String paymentNum) {
        AlipayTradeQueryModel model = new AlipayTradeQueryModel();
        model.setOutTradeNo(paymentNum);
        return model;
    }

    private AlipayTradeQueryRequest createTradeQueryRequest(String paymentNum) {
        AlipayTradeQueryRequest alipayTradeQueryRequest = new AlipayTradeQueryRequest();
        alipayTradeQueryRequest.setBizModel((AlipayObject)this.createTradeQueryModel(paymentNum));
        return alipayTradeQueryRequest;
    }

    @Override
    public Message submitRefund(PaymentRefundParam param) {
        log.debug("\u53d1\u8d77\u652f\u4ed8\u5b9d\u9000\u6b3e\u7533\u8bf7,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        BigDecimal totalFee = param.getPayOrder().getAmount();
        String outRefundNo = this.buildRefundOrderNo(param);
        BigDecimal refundFee = param.getFullAmount() != false ? totalFee : param.getRefundFee();
        AlipayTradeRefundModel model = new AlipayTradeRefundModel();
        model.setTradeNo(param.getPayOrder().getTradeNo());
        model.setOutRequestNo(outRefundNo);
        model.setRefundAmount(NumberUtils.format((double)refundFee.setScale(2, RoundingMode.HALF_DOWN).floatValue()));
        model.setRefundReason("\u8ba2\u5355\u9000\u6b3e");
        AlipayTradeRefundRequest tradeRefundRequest = new AlipayTradeRefundRequest();
        tradeRefundRequest.setBizModel((AlipayObject)model);
        try {
            this.createRefundOrder(param, outRefundNo, refundFee);
            System.out.println(JSONObject.toJSONString((Object)tradeRefundRequest));
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)this.alipayClient.execute((AlipayRequest)tradeRefundRequest);
            if (!StringUtils.equalsAny((CharSequence)response.getCode(), (CharSequence[])new CharSequence[]{SUCCESS_CODE})) {
                log.error("\u652f\u4ed8\u5b9d\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)param, (Object)JSON.toJSONString((Object)response));
                this.changeRefundOrderStatus(outRefundNo, response.getTradeNo(), JSON.toJSONString((Object)response), PaymentStatusEnum.REFUND_FAIL);
                return Message.build((boolean)false, (String)"\u9000\u6b3e\u7533\u8bf7\u5931\u8d25");
            }
            log.info("\u652f\u4ed8\u7533\u8bf7\u9000\u6b3e\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)param, (Object)JSON.toJSONString((Object)response));
            this.changeRefundOrderStatus(outRefundNo, response.getTradeNo(), JSON.toJSONString((Object)response), PaymentStatusEnum.REFUND);
        }
        catch (AlipayApiException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Message.build((boolean)false, (String)"\u9000\u6b3e\u7533\u8bf7\u5f02\u5e38");
        }
        this.logger.debug("\u652f\u4ed8\u9000\u6b3e\u7533\u8bf7\u5904\u7406\u5b8c\u6210,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        return Message.build((boolean)true);
    }

    @Override
    public String execRefundCallback(String callbackRequest) {
        throw new UnsupportedOperationException("\u652f\u4ed8\u5b9d\u65e0\u9000\u6b3e\u56de\u8c03\u5904\u7406");
    }

    @Override
    protected String buildRefundOrderNo(PaymentRefundParam param) {
        return "R" + param.getPayOrder().getPaymentNum();
    }
}

