/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.pay.impl;

import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.domain.PaymentOrderMapper;
import com.bxm.localnews.payment.domain.UserPayorderRefundMapper;
import com.bxm.localnews.payment.param.PaymentRefundParam;
import com.bxm.localnews.payment.param.UserPayorderRefundBean;
import com.bxm.localnews.payment.pay.PayModeService;
import com.bxm.localnews.payment.pay.PaymentOrderService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.math.BigDecimal;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPayModeService
implements PayModeService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PaymentOrderMapper paymentOrderMapper;
    @Autowired
    private UserPayorderRefundMapper userPayorderRefundMapper;
    @Autowired
    protected PaymentOrderService payService;
    @Resource
    private SequenceCreater sequenceCreater;

    protected void changeRefundOrderStatus(String refundOrderNo, String refundTradeNo, String result, PaymentStatusEnum status) {
        this.userPayorderRefundMapper.updateByOrderNo(UserPayorderRefundBean.builder().refundOrderNo(refundOrderNo).refundTradeNo(refundTradeNo).result(result).status(status.getType()).build());
        this.paymentOrderMapper.updateRefundOrder(refundTradeNo, status.getType());
    }

    protected void createRefundOrder(PaymentRefundParam param, String refundOrderNo, BigDecimal refundFee) {
        UserPayorderRefundBean history = this.userPayorderRefundMapper.selectByOrderNo(refundOrderNo);
        UserPayorderRefundBean refundBean = UserPayorderRefundBean.builder().id(this.sequenceCreater.nextLongId()).createTime(new Date()).operatorId(param.getOperatorId()).orderId(param.getPayOrder().getId()).refundOrderNo(refundOrderNo).refundFee(refundFee).remark(param.getRemark()).status(PaymentStatusEnum.REFUNDING.getType()).build();
        if (null != history) {
            refundBean.setId(history.getId());
            refundBean.setResult("");
            refundBean.setCreateTime(null);
            this.userPayorderRefundMapper.updateByPrimaryKeySelective(refundBean);
        } else {
            this.userPayorderRefundMapper.insert(refundBean);
        }
        this.paymentOrderMapper.updateRefundOrder(param.getPayOrder().getPaymentNum(), PaymentStatusEnum.REFUNDING.getType());
    }

    protected String buildRefundOrderNo(PaymentRefundParam param) {
        return "R" + param.getPayOrder().getPaymentNum();
    }
}

