/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.pay.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.activity.service.VipFacadeService;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.domain.PaymentOrderMapper;
import com.bxm.localnews.payment.dto.OrderStatusDTO;
import com.bxm.localnews.payment.order.OrderProcesserManager;
import com.bxm.localnews.payment.pay.PayProxyService;
import com.bxm.localnews.payment.pay.PaymentOrderService;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentOrderServiceImpl
implements PaymentOrderService {
    private static final Logger log = LoggerFactory.getLogger(PaymentOrderServiceImpl.class);
    private PaymentOrderMapper paymentOrderMapper;
    private PayProxyService payProxyService;
    private RedisStringAdapter redisStringAdapter;
    private VipFacadeService vipFacadeService;
    private final OrderProcesserManager orderProcesserManager;
    private final BizLogService bizLogService;

    @Autowired
    public PaymentOrderServiceImpl(PaymentOrderMapper paymentOrderMapper, PayProxyService payProxyService, RedisStringAdapter redisStringAdapter, VipFacadeService vipFacadeService, OrderProcesserManager orderProcesserManager, BizLogService bizLogService) {
        this.paymentOrderMapper = paymentOrderMapper;
        this.payProxyService = payProxyService;
        this.redisStringAdapter = redisStringAdapter;
        this.vipFacadeService = vipFacadeService;
        this.orderProcesserManager = orderProcesserManager;
        this.bizLogService = bizLogService;
    }

    public OrderStatusDTO queryOrder(String paymentNum) {
        return new OrderStatusDTO(paymentNum, this.getOrderStatus(paymentNum));
    }

    @Override
    public Message modifyStatus(PaymentOrder paymentOrder) {
        return this.modifyPaymentOrderStatus(paymentOrder);
    }

    @Override
    public Message modifyPaymentOrderStatus(PaymentOrder paymentOrder) {
        log.debug("\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)paymentOrder));
        if (this.paymentOrderMapper.updateByPrimaryKey(paymentOrder) > 0) {
            this.redisStringAdapter.set(this.getOrderStatusKey(paymentOrder.getPaymentNum()), (Object)paymentOrder.getStatus(), 86400L);
        }
        Message message = Message.build();
        if (Objects.equals(PaymentStatusEnum.SUCCEED.getType(), paymentOrder.getStatus())) {
            message.append(this.orderProcesserManager.get(paymentOrder.getOrderType()).afterPayment(paymentOrder));
            if (!message.isSuccess()) {
                log.error("\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5931\u8d25\uff1a{},\u8ba2\u5355\u53c2\u6570\uff1a{}", (Object)message.getLastMessage(), (Object)JSON.toJSONString((Object)paymentOrder));
            } else {
                PointReportParam reportParam = PointReportParam.build().e("3034").ev("118." + paymentOrder.getId()).put("uid", String.valueOf(paymentOrder.getUserId()));
                if (paymentOrder.getPlatform() != null) {
                    reportParam.dtype(paymentOrder.getPlatform().toString());
                }
                this.bizLogService.report(reportParam);
            }
        }
        return message;
    }

    @Override
    public PaymentOrder getPaymentOrderByPaymentNo(String paymentNum) {
        return this.paymentOrderMapper.queryByNo(paymentNum);
    }

    @Override
    public OrderStatusDTO queryOrderStatus(String paymentNum, Byte payType) {
        PaymentOrder paymentOrder = this.getPaymentOrderByPaymentNo(paymentNum);
        if (PaymentStatusEnum.WAIT.getType().equals(paymentOrder.getStatus())) {
            this.payProxyService.query(paymentOrder, PayTypeEnum.getPayTypeEnum(payType));
        }
        return new OrderStatusDTO(paymentNum, this.getOrderStatus(paymentNum));
    }

    private KeyGenerator getOrderStatusKey(String paymentNum) {
        return RedisConfig.WEIXIN_ORDER_STATUS.copy().appendKey((Object)paymentNum);
    }

    private Byte getOrderStatus(String paymentNum) {
        String status = this.redisStringAdapter.getString(this.getOrderStatusKey(paymentNum));
        if (StringUtils.isEmpty((CharSequence)status)) {
            PaymentOrder paymentOrder = this.getPaymentOrderByPaymentNo(paymentNum);
            if (paymentOrder == null) {
                log.info("\u8bf7\u6c42\u67e5\u8be2\u7684\u8ba2\u5355\u7f16\u53f7[{}]\u4e0d\u5b58\u5728", (Object)paymentNum);
                this.redisStringAdapter.set(this.getOrderStatusKey(paymentNum), (Object)PaymentStatusEnum.FAILED.getType(), 3600L);
                return null;
            }
            this.redisStringAdapter.set(this.getOrderStatusKey(paymentNum), (Object)paymentOrder.getStatus(), 86400L);
            return paymentOrder.getStatus();
        }
        return Byte.valueOf(status);
    }
}

