/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.pay.wechat;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.payment.config.WxPayProperties;
import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.param.PaymentRefundParam;
import com.bxm.localnews.payment.pay.PaymentOrderService;
import com.bxm.localnews.payment.pay.impl.AbstractPayModeService;
import com.bxm.localnews.payment.pay.wechat.WxWithdrawProxyService;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.notify.WxPayRefundNotifyResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.request.WxPayRefundRequest;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWechatPayModeService
extends AbstractPayModeService {
    private static final Logger log = LoggerFactory.getLogger(AbstractWechatPayModeService.class);
    protected String succssCode = "SUCCESS";
    @Autowired
    protected WxWithdrawProxyService wxWithdrawProxyService;
    @Autowired
    protected WxPayService wxPayService;
    @Autowired
    protected PaymentOrderService payService;
    @Autowired
    private WxPayProperties properties;

    @Override
    public String callBack(String data) {
        WxPayOrderNotifyResult result = this.wxWithdrawProxyService.parseOrderNotifyResult(data);
        String paymentNum = result.getOutTradeNo();
        PaymentOrder paymentOrder = this.payService.getPaymentOrderByPaymentNo(paymentNum);
        if (paymentOrder == null) {
            log.error("\u63a5\u6536\u5230\u7684\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u53c2\u6570\u9519\u8bef,\u652f\u4ed8\u8ba2\u5355[{}]\u4e0d\u5b58\u5728", (Object)paymentNum);
            return null;
        }
        Integer amount = BaseWxPayRequest.yuanToFen((String)paymentOrder.getAmount().toString());
        if (amount.intValue() != result.getTotalFee().intValue()) {
            log.error("\u652f\u4ed8\u8ba2\u5355\u652f\u4ed8\u91d1\u989d[{}]\u4e0e\u5fae\u4fe1\u8fd4\u56de\u7684\u8ba2\u5355\u603b\u91d1\u989d[{}]\u4e0d\u5339\u914d", (Object)amount, (Object)result.getTotalFee());
            return null;
        }
        if (!this.succssCode.equals(result.getReturnCode()) || !this.succssCode.equals(result.getResultCode())) {
            this.logger.error("\u8ba2\u5355[{}]\u56de\u8c03\u7ed3\u679c\u4e3a\u5931\u8d25", (Object)paymentNum);
            return null;
        }
        if (PaymentStatusEnum.SUCCEED.getType().equals(paymentOrder.getStatus())) {
            return this.succssCode;
        }
        if (!PaymentStatusEnum.WAIT.getType().equals(paymentOrder.getStatus())) {
            this.logger.warn("\u8ba2\u5355[{}]\u5f53\u524d\u72b6\u6001\u4e0d\u662f\u5f85\u4ed8\u6b3e\uff0c\u6b64\u60c5\u51b5\u662f\u5f02\u5e38\u72b6\u6001\uff0c\u8bf7\u6ce8\u610f\u4e1a\u52a1\u6d41\u7a0b\u548c\u903b\u8f91", (Object)paymentNum);
        }
        this.query(paymentOrder);
        return this.succssCode;
    }

    @Override
    public void query(PaymentOrder paymentOrder) {
        WxPayOrderQueryResult result = this.wxWithdrawProxyService.queryOrder(paymentOrder.getPaymentNum(), (byte)1);
        if (!this.succssCode.equals(result.getReturnCode()) || !this.succssCode.equals(result.getResultCode())) {
            log.error("\u67e5\u8be2\u8ba2\u5355[{}]\u5fae\u4fe1\u652f\u4ed8\u5931\u8d25", (Object)paymentOrder.getPaymentNum());
            return;
        }
        if (this.succssCode.equals(result.getTradeState())) {
            this.afterPaySucceed(result, paymentOrder);
        } else {
            this.afterPayClose(result, paymentOrder);
        }
    }

    private void afterPayClose(WxPayOrderQueryResult result, PaymentOrder paymentOrder) {
        paymentOrder.setStatus(PaymentStatusEnum.UNDO.getType());
        paymentOrder.setFinishTime(DateUtils.parseDateNonStrict((String)result.getTimeEnd()));
        paymentOrder.setResult(result.getTradeState());
        paymentOrder.setTradeNo(result.getTransactionId());
        this.payService.modifyPaymentOrderStatus(paymentOrder);
    }

    private void afterPaySucceed(WxPayOrderQueryResult result, PaymentOrder paymentOrder) {
        paymentOrder.setStatus(PaymentStatusEnum.SUCCEED.getType());
        paymentOrder.setFinishTime(DateUtils.parseDateNonStrict((String)result.getTimeEnd()));
        paymentOrder.setResult(result.getErrCodeDes());
        paymentOrder.setTradeNo(result.getTransactionId());
        this.payService.modifyPaymentOrderStatus(paymentOrder);
    }

    private String buildSuccessResponse() {
        return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>";
    }

    @Override
    public String execRefundCallback(String callbackRequest) {
        log.info("\u5fae\u4fe1\u9000\u6b3e\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)callbackRequest);
        try {
            WxPayRefundNotifyResult notifyResult = this.wxPayService.parseRefundNotifyResult(callbackRequest);
            if (StringUtils.equals((String)notifyResult.getReturnCode(), (String)this.succssCode)) {
                if (StringUtils.equals((String)notifyResult.getReqInfo().getRefundStatus(), (String)this.succssCode)) {
                    this.changeRefundOrderStatus(notifyResult.getReqInfo().getOutTradeNo(), notifyResult.getReqInfo().getOutRefundNo(), JSON.toJSONString((Object)notifyResult.getReqInfo()), PaymentStatusEnum.REFUND);
                } else {
                    log.error("\u9000\u6b3e\u4e1a\u52a1\u72b6\u6001\u5f02\u5e38\uff0c\u56de\u8c03\u53c2\u6570\uff1a{}\uff0c\u56de\u8c03\u7ed3\u679c\uff1a{}", (Object)callbackRequest, (Object)JSON.toJSONString((Object)notifyResult));
                    this.changeRefundOrderStatus(notifyResult.getReqInfo().getOutTradeNo(), notifyResult.getReqInfo().getOutRefundNo(), JSON.toJSONString((Object)notifyResult.getReqInfo()), PaymentStatusEnum.REFUND_FAIL);
                }
            } else {
                log.error("\u5fae\u4fe1\u9000\u6b3e\u5931\u8d25\uff0c\u56de\u8c03\u53c2\u6570\uff1a{}\uff0c\u56de\u8c03\u7ed3\u679c\uff1a{}", (Object)callbackRequest, (Object)JSON.toJSONString((Object)notifyResult));
            }
            return this.buildSuccessResponse();
        }
        catch (WxPayException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Message submitRefund(PaymentRefundParam param) {
        log.debug("\u53d1\u8d77\u9000\u6b3e\u7533\u8bf7\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        WxPayRefundRequest request = new WxPayRefundRequest();
        try {
            BigDecimal multiple = new BigDecimal("100");
            BigDecimal totalFee = param.getPayOrder().getAmount().multiply(multiple);
            String outRefundNo = this.buildRefundOrderNo(param);
            BigDecimal refundFee = param.getFullAmount() != false ? totalFee : param.getRefundFee().multiply(multiple);
            request.setTransactionId(param.getPayOrder().getTradeNo());
            request.setOutRefundNo(outRefundNo);
            request.setTotalFee(Integer.valueOf(totalFee.intValue()));
            request.setRefundFee(Integer.valueOf(refundFee.intValue()));
            request.setOpUserId(this.wxPayService.getConfig().getMchId());
            request.setNotifyUrl(this.properties.getRefundNotifyUrl());
            request.checkAndSign(this.wxPayService.getConfig());
            WxPayRefundResult refundResult = this.wxPayService.refund(request);
            if (!StringUtils.equals((String)refundResult.getReturnCode(), (String)this.succssCode)) {
                log.error("\u9000\u6b3e\u7533\u8bf7\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)param, (Object)JSON.toJSONString((Object)refundResult));
                return Message.build((boolean)false, (String)"\u5fae\u4fe1\u652f\u4ed8\u8c03\u7528\u5931\u8d25");
            }
            log.info("\u7533\u8bf7\u9000\u6b3e\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)param, (Object)JSON.toJSONString((Object)refundResult));
            this.createRefundOrder(param, outRefundNo, refundFee.divide(multiple, RoundingMode.HALF_DOWN));
            log.debug("\u9000\u6b3e\u7533\u8bf7\u53d1\u8d77\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u503c\uff1a{}", (Object)param, (Object)JSON.toJSONString((Object)refundResult));
        }
        catch (WxPayException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return Message.build((boolean)false, (String)"\u8c03\u7528\u5fae\u4fe1\u652f\u4ed8\u5e73\u53f0\u9000\u6b3eAPI\u5931\u8d25");
        }
        return Message.build((boolean)true);
    }

    @Override
    protected String buildRefundOrderNo(PaymentRefundParam param) {
        return "R" + param.getPayOrder().getPaymentNum();
    }
}

