/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.pay.wechat;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.pay.PaymentOrderService;
import com.bxm.localnews.payment.pay.wechat.AbstractWechatPayModeService;
import com.bxm.localnews.payment.pay.wechat.WxWithdrawProxyService;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.gexin.fastjson.JSON;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatPayModeServiceImpl
extends AbstractWechatPayModeService {
    private static final Logger log = LoggerFactory.getLogger(WechatPayModeServiceImpl.class);
    private final WxWithdrawProxyService wxWithdrawProxyService;
    private final PaymentOrderService payService;

    @Autowired
    public WechatPayModeServiceImpl(WxWithdrawProxyService wxWithdrawProxyService, PaymentOrderService payService) {
        this.wxWithdrawProxyService = wxWithdrawProxyService;
        this.payService = payService;
    }

    @Override
    public PayTypeEnum support() {
        return PayTypeEnum.WX_PAY;
    }

    @Override
    public void create(PaymentOrderDetail paymentOrderDetail) {
        if (Objects.equals(PlatformEnum.APPLET.getCode(), paymentOrderDetail.getPlatform())) {
            WxPayAppOrderResult result = this.wxWithdrawProxyService.createAppOrder(paymentOrderDetail);
            paymentOrderDetail.setLink(JSON.toJSONString((Object)result));
        } else {
            WxPayMwebOrderResult webOrderResult = this.wxWithdrawProxyService.createWebOrder(paymentOrderDetail);
            if (Objects.nonNull(webOrderResult)) {
                paymentOrderDetail.setLink(webOrderResult.getMwebUrl());
            }
        }
    }
}

