/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.withdraw.strategy;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.payment.WithdrwaStrategyEnum;
import com.bxm.localnews.payment.withdraw.WithdrawContext;
import com.bxm.localnews.payment.withdraw.strategy.AbstractWithdrawStrategy;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import java.text.DateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DailyOnceWithdrawStrategy
extends AbstractWithdrawStrategy {
    private final RedisSetAdapter redisSetAdapter;

    @Autowired
    public DailyOnceWithdrawStrategy(RedisSetAdapter redisSetAdapter) {
        this.redisSetAdapter = redisSetAdapter;
    }

    @Override
    public WithdrwaStrategyEnum match() {
        return WithdrwaStrategyEnum.DAILY_ONCE;
    }

    @Override
    public Message execWithdraw(WithdrawContext context) {
        Message message = this.directWithdraw(context);
        if (message.isSuccess()) {
            this.redisSetAdapter.add(this.buildKey(context.getUserId()), new Object[]{context.getUserId()});
        }
        return message;
    }

    private KeyGenerator buildKey(Long userId) {
        String today = ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
        return RedisConfig.WITHDRAW_DAILY_ONCE_RECORD.copy().appendKey((Object)today).appendKey((Object)(userId % 10L));
    }

    @Override
    public boolean hasTimes(Long userId) {
        boolean exists = this.redisSetAdapter.exists(this.buildKey(userId), (Object)userId);
        return !exists;
    }
}

